/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader;

import android.content.Context;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.AbstractAuthenticationLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;

public class LoginLoader
extends AbstractAuthenticationLoader {
    private static final String TAG = LoginLoader.class.getSimpleName();
    private HeaderAndBody result = null;
    private final Map<String, String> loginData;

    LoginLoader(Context context, Callback callback, AuthenticationModule module, Map<String, String> loginData) {
        super(context, module, callback);
        this.loginData = new HashMap<String, String>(loginData);
    }

    public HeaderAndBody loadInBackground() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.module.login(this.loginData, new Callback<HeaderAndBody>(){

            public void onSuccess(HeaderAndBody data) {
                LoginLoader.this.result = data;
                latch.countDown();
            }

            public void onFailure(Exception e) {
                LoginLoader.super.setException(e);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
        return this.result;
    }

    protected void onStartLoading() {
        if (this.module.isLoggedIn() && this.result != null) {
            this.deliverResult(this.result);
        } else {
            this.forceLoad();
        }
    }
}

