/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication;

import android.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.pipe.http.HttpProviderFactory;
import org.jboss.aerogear.android.pipe.util.UrlUtils;

public abstract class AbstractAuthenticationModuleRunner {
    private static final String TAG = AbstractAuthenticationModuleRunner.class.getSimpleName();
    protected final URL baseURL;
    protected final String enrollEndpoint;
    protected final URL enrollURL;
    protected final Provider<HttpProvider> httpProviderFactory = new HttpProviderFactory();
    protected final String loginEndpoint;
    protected final URL loginURL;
    protected final String logoutEndpoint;
    protected final URL logoutURL;
    protected final Integer timeout;

    public AbstractAuthenticationModuleRunner(URL baseURL, String loginEndpoint, String logoutEndpoint, String enrollEndpoint, Integer timeout) {
        this.baseURL = baseURL;
        this.loginEndpoint = loginEndpoint;
        this.logoutEndpoint = logoutEndpoint;
        this.enrollEndpoint = enrollEndpoint;
        this.loginURL = UrlUtils.appendToBaseURL((URL)baseURL, (String)loginEndpoint);
        this.logoutURL = UrlUtils.appendToBaseURL((URL)baseURL, (String)logoutEndpoint);
        this.enrollURL = UrlUtils.appendToBaseURL((URL)baseURL, (String)enrollEndpoint);
        this.timeout = timeout;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public URI getBaseURI() {
        try {
            return this.baseURL.toURI();
        }
        catch (URISyntaxException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String getEnrollEndpoint() {
        return this.enrollEndpoint;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public abstract HeaderAndBody onEnroll(Map<String, String> var1);

    public abstract HeaderAndBody onLogin(String var1, String var2);

    public abstract void onLogout();
}

