/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.test.oauth2;

import android.app.Activity;
import android.os.Looper;
import android.support.test.runner.AndroidJUnit4;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.aerogear.android.authorization.AuthorizationManager;
import org.jboss.aerogear.android.authorization.AuthzModule;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationConfiguration;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.authorization.oauth2.intent.OAuth2IntentAuthzModule;
import org.jboss.aerogear.android.authorization.test.MainActivity;
import org.jboss.aerogear.android.authorization.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.core.Callback;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=AndroidJUnit4.class)
public class IntentOAuth2AuthzModuleTest
extends PatchedActivityInstrumentationTestCase {
    private static final URL BASE_URL;

    public IntentOAuth2AuthzModuleTest() {
        super(MainActivity.class);
    }

    @Test
    public void testWithIntentCreatesIntentModule() {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        config.setWithIntent(true);
        AuthzModule module = config.asModule();
        Assert.assertTrue((boolean)(module instanceof OAuth2IntentAuthzModule));
    }

    @Test
    public void testIntentPutsAccountOnModule() throws Exception {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        config.setAccountId("ignore");
        config.setWithIntent(true);
        AuthzModule module = config.asModule();
        Assert.assertNull((Object)MainActivity.UnitTestUtils.getSuperPrivateField(module, "account"));
        Method doRequestAccessMethod = OAuth2IntentAuthzModule.class.getDeclaredMethod("doRequestAccess", String.class, Activity.class, Callback.class, OAuth2AuthzService.AGAuthzServiceConnection.class);
        OAuth2AuthzService.AGAuthzServiceConnection mockConnection = (OAuth2AuthzService.AGAuthzServiceConnection)Mockito.mock(OAuth2AuthzService.AGAuthzServiceConnection.class);
        OAuth2AuthzService mockService = (OAuth2AuthzService)Mockito.mock(OAuth2AuthzService.class);
        ((OAuth2AuthzService)Mockito.doReturn((Object)Mockito.mock(OAuth2AuthzSession.class)).when((Object)mockService)).getAccount((String)Matchers.any(String.class));
        ((OAuth2AuthzService)Mockito.doReturn((Object)true).when((Object)mockService)).hasAccount((String)Matchers.any(String.class));
        ((OAuth2AuthzService)Mockito.doReturn((Object)"testToken").when((Object)mockService)).fetchAccessToken((String)Matchers.any(String.class), (OAuth2Properties)Matchers.any(OAuth2Properties.class));
        ((OAuth2AuthzService.AGAuthzServiceConnection)Mockito.doReturn((Object)mockService).when((Object)mockConnection)).getService();
        Looper.prepare();
        doRequestAccessMethod.setAccessible(true);
        doRequestAccessMethod.invoke((Object)module, "ignore", this.getActivity(), Mockito.mock(Callback.class), mockConnection);
        Assert.assertNotNull((Object)MainActivity.UnitTestUtils.getSuperPrivateField(module, "account"));
    }

    static {
        try {
            BASE_URL = new URL("https://example.com");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

