/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.test.oauth2;

import android.app.Activity;
import android.content.Intent;
import android.content.ServiceConnection;
import android.support.test.annotation.UiThreadTest;
import android.support.test.runner.AndroidJUnit4;
import android.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.aerogear.android.authorization.AuthorizationManager;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationConfiguration;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzModule;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.authorization.oauth2.webview.OAuth2WebViewAuthzModule;
import org.jboss.aerogear.android.authorization.test.MainActivity;
import org.jboss.aerogear.android.authorization.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.authorization.test.util.VoidCallback;
import org.jboss.aerogear.android.core.Callback;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=AndroidJUnit4.class)
public class OAuth2AuthzModuleTest
extends PatchedActivityInstrumentationTestCase {
    private static final URL BASE_URL;

    public OAuth2AuthzModuleTest() {
        super(MainActivity.class);
    }

    @Test(expected=IllegalStateException.class)
    public void testRequiresBaseURL() {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
    }

    @Test
    public void testCreation() throws MalformedURLException {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        Assert.assertFalse((boolean)module.isAuthorized());
        Assert.assertEquals((Object)module, (Object)AuthorizationManager.getModule((String)"name"));
    }

    @Test
    public void testRequestAccess() {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        Activity mockActivity = (Activity)Mockito.mock(Activity.class);
        Callback mockCallback = (Callback)Mockito.mock(Callback.class);
        Mockito.when((Object)mockActivity.bindService((Intent)Matchers.any(Intent.class), (ServiceConnection)Matchers.any(ServiceConnection.class), ((Integer)Matchers.any(Integer.class)).intValue())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockActivity.getApplicationContext()).thenReturn((Object)super.getActivity());
        module.requestAccess(mockActivity, mockCallback);
        ((Activity)Mockito.verify((Object)mockActivity, (VerificationMode)Mockito.times((int)1))).bindService((Intent)Matchers.any(), (ServiceConnection)Matchers.any(), ((Integer)Matchers.any(Integer.class)).intValue());
    }

    @Test
    public void testGetAccessTokens() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        OAuth2AuthzSession account = new OAuth2AuthzSession();
        account.setAccessToken("testToken");
        MainActivity.UnitTestUtils.setPrivateField(module, "account", account);
        Assert.assertEquals((Object)"Bearer testToken", (Object)((Pair)module.getAuthorizationFields(null, null, null).getHeaders().get((int)0)).second);
        Assert.assertEquals((Object)"Authorization", (Object)((Pair)module.getAuthorizationFields(null, null, null).getHeaders().get((int)0)).first);
    }

    @UiThreadTest
    public void testOAuth2AuthorizationCallback() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, OAuth2AuthorizationException, InterruptedException {
        OAuth2AuthzService mockService = (OAuth2AuthzService)Mockito.mock(OAuth2AuthzService.class);
        Activity mockActivity = (Activity)Mockito.mock(Activity.class);
        ServiceConnection mockServiceConnection = (ServiceConnection)Mockito.mock(ServiceConnection.class);
        ArgumentCaptor sessionCaptor = ArgumentCaptor.forClass(OAuth2AuthzSession.class);
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setAccountId("testAccountId");
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        Class<?> callbackClass = Class.forName("org.jboss.aerogear.android.authorization.oauth2.webview.OAuth2WebViewAuthzModule$OAuth2AuthorizationCallback");
        Constructor<?> constructor = callbackClass.getDeclaredConstructor(OAuth2WebViewAuthzModule.class, Activity.class, Callback.class, ServiceConnection.class);
        constructor.setAccessible(true);
        Callback callback = (Callback)constructor.newInstance(module, mockActivity, new VoidCallback(), mockServiceConnection);
        MainActivity.UnitTestUtils.setPrivateField(module, "service", mockService);
        callback.onSuccess((Object)"testCode");
        ((OAuth2AuthzService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).addAccount((OAuth2AuthzSession)sessionCaptor.capture());
        OAuth2AuthzSession account = (OAuth2AuthzSession)sessionCaptor.getValue();
        Assert.assertEquals((Object)"testCode", (Object)account.getAuthorizationCode());
    }

    @UiThreadTest
    public void testOAuth2AccessCallback() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        OAuth2AuthzService mockService = (OAuth2AuthzService)Mockito.mock(OAuth2AuthzService.class);
        Activity mockActivity = (Activity)Mockito.mock(Activity.class);
        ServiceConnection mockServiceConnection = (ServiceConnection)Mockito.mock(ServiceConnection.class);
        OAuth2AuthzSession account = new OAuth2AuthzSession();
        account.setAccessToken("testToken");
        Mockito.when((Object)mockService.getAccount(Matchers.matches((String)"testAccountId"))).thenReturn((Object)account);
        OAuth2AuthorizationConfiguration config = (OAuth2AuthorizationConfiguration)AuthorizationManager.config((String)"name", OAuth2AuthorizationConfiguration.class);
        config.setAccountId("testAccountId");
        config.setBaseURL(BASE_URL);
        OAuth2AuthzModule module = (OAuth2AuthzModule)config.asModule();
        Class<?> callbackClass = Class.forName("org.jboss.aerogear.android.authorization.oauth2.webview.OAuth2WebViewAuthzModule$OAuth2AccessCallback");
        Constructor<?> constructor = callbackClass.getDeclaredConstructor(OAuth2WebViewAuthzModule.class, Activity.class, Callback.class, ServiceConnection.class);
        constructor.setAccessible(true);
        Callback callback = (Callback)constructor.newInstance(module, mockActivity, new VoidCallback(), mockServiceConnection);
        MainActivity.UnitTestUtils.setPrivateField(module, "service", mockService);
        callback.onSuccess((Object)"testToken");
        ((Activity)Mockito.verify((Object)mockActivity, (VerificationMode)Mockito.times((int)1))).unbindService((ServiceConnection)Matchers.eq((Object)mockServiceConnection));
        Assert.assertEquals((Object)"testToken", (Object)((OAuth2AuthzSession)MainActivity.UnitTestUtils.getSuperPrivateField(module, "account")).getAccessToken());
    }

    static {
        try {
            BASE_URL = new URL("https://example.com");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

