/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import android.util.Pair;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.android.Config;
import org.jboss.aerogear.android.authorization.AuthzModule;
import org.jboss.aerogear.android.impl.authz.AuthorizationConfiguration;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzModule;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2Properties;

public class OAuth2AuthorizationConfiguration
extends AuthorizationConfiguration<OAuth2AuthorizationConfiguration>
implements Config<OAuth2AuthorizationConfiguration> {
    private String authzEndpoint = "";
    private String refreshEndpoint = "";
    private String redirectURL = "";
    private URL baseURL;
    private String accessTokenEndpoint = "";
    private List<String> scopes = new ArrayList<String>();
    private String clientId = "";
    private String clientSecret = "";
    private String accountId = "";
    private Set<Pair<String, String>> additionalAuthorizationParams = new HashSet<Pair<String, String>>();
    private Set<Pair<String, String>> additionalAccessParams = new HashSet<Pair<String, String>>();

    public String getAuthzEndpoint() {
        return this.authzEndpoint;
    }

    public OAuth2AuthorizationConfiguration setAuthzEndpoint(String authzEndpoint) {
        this.authzEndpoint = authzEndpoint;
        return this;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public OAuth2AuthorizationConfiguration setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
        return this;
    }

    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    public OAuth2AuthorizationConfiguration setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public OAuth2AuthorizationConfiguration setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OAuth2AuthorizationConfiguration setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2AuthorizationConfiguration setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public OAuth2AuthorizationConfiguration setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public Set<Pair<String, String>> getAdditionalAuthorizationParams() {
        return this.additionalAuthorizationParams;
    }

    public OAuth2AuthorizationConfiguration setAdditionalAuthorizationParams(Set<Pair<String, String>> additionalAuthorizationParams) {
        this.additionalAuthorizationParams = additionalAuthorizationParams;
        return this;
    }

    public Set<Pair<String, String>> getAdditionalAccessParams() {
        return this.additionalAccessParams;
    }

    public OAuth2AuthorizationConfiguration setAdditionalAccessParams(Set<Pair<String, String>> additionalAccessParams) {
        this.additionalAccessParams = additionalAccessParams;
        return this;
    }

    @Override
    protected AuthzModule buildModule() {
        if (this.baseURL == null) {
            throw new IllegalStateException("BaseURL may not be null");
        }
        OAuth2Properties params = new OAuth2Properties(this.baseURL, this.getName());
        params.setAccessTokenEndpoint(this.accessTokenEndpoint);
        params.setAccountId(this.accountId);
        params.setAuthzEndpoint(this.authzEndpoint);
        params.setRefreshEndpoint(this.refreshEndpoint);
        params.setClientId(this.clientId);
        params.setClientSecret(this.clientSecret);
        params.setRedirectURL(this.redirectURL);
        params.setScopes(this.scopes);
        params.getAdditionalAccessParams().addAll(this.additionalAccessParams);
        params.getAdditionalAuthorizationParams().addAll(this.additionalAuthorizationParams);
        return new OAuth2AuthzModule(params);
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public OAuth2AuthorizationConfiguration setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    public String getRefreshEndpoint() {
        return this.refreshEndpoint;
    }

    public OAuth2AuthorizationConfiguration setRefreshEndpoint(String refreshEndpoint) {
        this.refreshEndpoint = refreshEndpoint;
        return this;
    }
}

