/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.UUID;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authorization.AuthzModule;
import org.jboss.aerogear.android.code.ModuleFields;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2FetchAccess;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.impl.authz.oauth2.OAuth2WebFragmentFetchAutorization;

public class OAuth2AuthzModule
implements AuthzModule {
    private static final IntentFilter AUTHZ_FILTER = new IntentFilter();
    private final String accountId;
    private final String clientId;
    private final OAuth2Properties config;
    private OAuth2AuthzSession account;
    private OAuth2AuthzService service;
    private String TAG = OAuth2AuthzModule.class.getSimpleName();

    public OAuth2AuthzModule(OAuth2Properties config) {
        this.clientId = config.getClientId();
        this.accountId = config.getAccountId();
        this.config = config;
    }

    @Override
    public boolean isAuthorized() {
        if (this.account == null) {
            return false;
        }
        return this.account.tokenIsNotExpired() && !Strings.isNullOrEmpty((String)this.account.getAccessToken());
    }

    @Override
    public boolean hasCredentials() {
        if (this.account == null) {
            return false;
        }
        return !Strings.isNullOrEmpty((String)this.account.getAccessToken());
    }

    @Override
    public void requestAccess(final Activity activity, final Callback<String> callback) {
        final String state = UUID.randomUUID().toString();
        OAuth2AuthzService.AGAuthzServiceConnection connection = new OAuth2AuthzService.AGAuthzServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName className, IBinder iBinder) {
                super.onServiceConnected(className, iBinder);
                OAuth2AuthzModule.this.doRequestAccess(state, activity, (Callback<String>)callback, this);
            }
        };
        activity.bindService(new Intent(activity.getApplicationContext(), OAuth2AuthzService.class), (ServiceConnection)connection, 1);
    }

    @Override
    public AuthorizationFields getAuthorizationFields(URI requestUri, String method, byte[] requestBody) {
        AuthorizationFields fields = new AuthorizationFields();
        fields.addHeader("Authorization", "Bearer " + this.account.getAccessToken());
        return fields;
    }

    private void doRequestAccess(String state, Activity activity, Callback<String> callback, OAuth2AuthzService.AGAuthzServiceConnection instance) {
        this.service = instance.getService();
        if (Strings.isNullOrEmpty((String)this.accountId)) {
            throw new IllegalArgumentException("need to have accountId set");
        }
        if (!this.service.hasAccount(this.accountId)) {
            OAuth2WebFragmentFetchAutorization authzFetch = new OAuth2WebFragmentFetchAutorization(activity, state);
            authzFetch.performAuthorization(this.config, new OAuth2AuthorizationCallback(activity, callback, instance));
        } else {
            OAuth2FetchAccess fetcher = new OAuth2FetchAccess(this.service);
            fetcher.fetchAccessCode(this.accountId, this.config, new OAuth2AccessCallback(activity, callback, instance));
        }
    }

    @Override
    public boolean refreshAccess() {
        if (!this.hasAccount()) {
            return false;
        }
        if (this.isAuthorized()) {
            return true;
        }
        try {
            this.account.setAccessToken(this.service.fetchAccessToken(this.accountId, this.config));
            Log.d((String)this.TAG, (String)"Access token refresh complete!");
            return true;
        }
        catch (OAuth2AuthorizationException ex) {
            Log.e((String)this.TAG, (String)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private boolean hasAccount() {
        return !Strings.isNullOrEmpty((String)this.accountId) && this.service.hasAccount(this.accountId);
    }

    public ModuleFields loadModule(URI relativeURI, String httpMethod, byte[] requestBody) {
        AuthorizationFields authzFields = this.getAuthorizationFields(relativeURI, httpMethod, requestBody);
        ModuleFields moduleFields = new ModuleFields();
        moduleFields.setHeaders(authzFields.getHeaders());
        moduleFields.setQueryParameters(authzFields.getQueryParameters());
        return moduleFields;
    }

    public boolean handleError(HttpException exception) {
        if (exception.getStatusCode() == 401 || exception.getStatusCode() == 403) {
            return this.isAuthorized() && this.refreshAccess();
        }
        return false;
    }

    @Override
    public void deleteAccount() {
        this.service.removeAccount(this.accountId);
    }

    static {
        AUTHZ_FILTER.addAction("org.jboss.aerogear.android.authz.RECEIVE_AUTHZ");
    }

    private class OAuth2AuthorizationCallback
    implements Callback<String> {
        private final Activity callingActivity;
        private final Callback<String> originalCallback;
        private final ServiceConnection serviceConnection;
        private final Handler myHandler;

        public OAuth2AuthorizationCallback(Activity callingActivity, Callback<String> originalCallback, ServiceConnection serviceConnection) {
            this.callingActivity = callingActivity;
            this.originalCallback = originalCallback;
            this.serviceConnection = serviceConnection;
            this.myHandler = new Handler(Looper.myLooper());
        }

        public void onSuccess(String code) {
            OAuth2AuthzSession session = new OAuth2AuthzSession();
            session.setAuthorizationCode(code);
            session.setAccountId(OAuth2AuthzModule.this.accountId);
            session.setClientId(OAuth2AuthzModule.this.clientId);
            OAuth2AuthzModule.this.service.addAccount(session);
            OAuth2FetchAccess fetcher = new OAuth2FetchAccess(OAuth2AuthzModule.this.service);
            fetcher.fetchAccessCode(OAuth2AuthzModule.this.accountId, OAuth2AuthzModule.this.config, new OAuth2AccessCallback(this.callingActivity, this.originalCallback, this.serviceConnection));
        }

        public void onFailure(final Exception e) {
            this.myHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        OAuth2AuthorizationCallback.this.callingActivity.unbindService(OAuth2AuthorizationCallback.this.serviceConnection);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    OAuth2AuthorizationCallback.this.originalCallback.onFailure(e);
                }
            });
        }
    }

    private class OAuth2AccessCallback
    implements Callback<String> {
        private final Activity callingActivity;
        private final Callback<String> originalCallback;
        private final ServiceConnection serviceConnection;
        private final Handler myHandler;

        public OAuth2AccessCallback(Activity callingActivity, Callback<String> originalCallback, ServiceConnection serviceConnection) {
            this.callingActivity = callingActivity;
            this.originalCallback = originalCallback;
            this.serviceConnection = serviceConnection;
            this.myHandler = new Handler(Looper.myLooper());
        }

        public void onSuccess(final String accessToken) {
            OAuth2AuthzModule.this.account = OAuth2AuthzModule.this.service.getAccount(OAuth2AuthzModule.this.accountId);
            try {
                this.callingActivity.unbindService(this.serviceConnection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.myHandler.post(new Runnable(){

                @Override
                public void run() {
                    OAuth2AccessCallback.this.originalCallback.onSuccess((Object)accessToken);
                }
            });
        }

        public void onFailure(final Exception e) {
            this.myHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        OAuth2AccessCallback.this.callingActivity.unbindService(OAuth2AccessCallback.this.serviceConnection);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    OAuth2AccessCallback.this.originalCallback.onFailure(e);
                }
            });
        }
    }
}

