/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz.oauth2;

import android.app.DialogFragment;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import java.net.URL;
import org.jboss.aerogear.android.authorization.R;

public class OAuthWebViewDialog
extends DialogFragment {
    private static final String TAG = OAuthWebViewDialog.class.getSimpleName();
    private static final String TITLE = "org.jboss.aerogear.android.authorize.OAuthWebViewDialog.TITLE";
    private static final String AUTHORIZE_URL = "org.jboss.aerogear.android.authorize.OAuthWebViewDialog.AUTHORIZE_URL";
    private static final String REDIRECT_URL = "org.jboss.aerogear.android.authorize.OAuthWebViewDialog.REDIRECT_URL";
    private WebView webView;
    private ProgressBar progressBar;
    private String authorizeUrl;
    private final OAuthViewClient client = new OAuthViewClient(){

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            OAuthWebViewDialog.this.progressBar.setVisibility(8);
        }
    };
    private String redirectURL;

    public static OAuthWebViewDialog newInstance(URL authorizeURL, Uri redirectURL) {
        OAuthWebViewDialog instance = new OAuthWebViewDialog();
        instance.authorizeUrl = authorizeURL.toString();
        instance.redirectURL = redirectURL.toString();
        Bundle args = new Bundle();
        args.putString(AUTHORIZE_URL, instance.authorizeUrl);
        args.putString(REDIRECT_URL, instance.redirectURL);
        instance.setArguments(args);
        return instance;
    }

    public void onViewCreated(View arg0, Bundle arg1) {
        super.onViewCreated(arg0, arg1);
        this.client.redirectURL = this.redirectURL;
        this.webView.loadUrl(this.authorizeUrl);
        this.webView.setWebViewClient((WebViewClient)this.client);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT > 18) {
            webSettings.setUseWideViewPort(true);
            webSettings.setLoadWithOverviewMode(true);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.authorizeUrl = this.getArguments().getString(AUTHORIZE_URL);
        this.redirectURL = this.getArguments().getString(REDIRECT_URL);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.oauth_web_view, container, false);
        this.progressBar = (ProgressBar)v.findViewById(R.id.progress_bar);
        this.webView = (WebView)v.findViewById(R.id.web_oauth);
        this.webView.setScrollContainer(true);
        this.getDialog().getWindow().setTitle((CharSequence)"OAuth 2 Dialog");
        return v;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.client.receiver != null) {
            this.client.receiver.receiveOAuthError("dialog_dismissed");
        }
    }

    public void setReceiver(OAuthReceiver receiver) {
        this.client.receiver = receiver;
    }

    public void removeReceive() {
        this.client.receiver = null;
    }

    public static interface OAuthReceiver {
        public static final String DISMISS_ERROR = "dialog_dismissed";

        public void receiveOAuthCode(String var1);

        public void receiveOAuthError(String var1);
    }

    private class OAuthViewClient
    extends WebViewClient {
        private OAuthReceiver receiver;
        private String redirectURL;

        private OAuthViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            if (url.startsWith(this.redirectURL)) {
                if (url.contains("code=")) {
                    final String token = this.fetchToken(url);
                    Log.d((String)"TOKEN", (String)token);
                    if (this.receiver != null) {
                        final OAuthReceiver receiverRef = this.receiver;
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                receiverRef.receiveOAuthCode(token);
                            }
                        });
                    }
                    return;
                }
                if (url.contains("error=")) {
                    final String error = this.fetchError(url);
                    Log.d((String)"ERROR", (String)error);
                    if (this.receiver != null) {
                        final OAuthReceiver receiverRef = this.receiver;
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                receiverRef.receiveOAuthError(error);
                            }
                        });
                    }
                    return;
                }
            }
            super.onPageFinished(view, url);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith(this.redirectURL)) {
                if (url.contains("code=")) {
                    final String token = this.fetchToken(url);
                    Log.d((String)"TOKEN", (String)token);
                    if (this.receiver != null) {
                        final OAuthReceiver receiverRef = this.receiver;
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                receiverRef.receiveOAuthCode(token);
                            }
                        });
                    }
                    return true;
                }
                if (url.contains("error=")) {
                    final String error = this.fetchError(url);
                    Log.d((String)"ERROR", (String)error);
                    if (this.receiver != null) {
                        final OAuthReceiver receiverRef = this.receiver;
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                receiverRef.receiveOAuthError(error);
                            }
                        });
                    }
                    return true;
                }
            }
            return false;
        }

        private String fetchToken(String url) {
            return this.fetchURLParam(url, "code");
        }

        private String fetchError(String url) {
            return this.fetchURLParam(url, "error");
        }

        private String fetchURLParam(String url, String param) {
            Uri uri = Uri.parse((String)url);
            return uri.getQueryParameter(param);
        }
    }
}

