/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2;

import android.app.Activity;
import android.net.Uri;
import android.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.authorization.oauth2.OAuthWebViewDialog;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.pipe.util.UrlUtils;

public class OAuth2WebFragmentFetchAutorization {
    private final Activity activity;
    private final String state;

    public OAuth2WebFragmentFetchAutorization(Activity activity, String state) {
        this.activity = activity;
        this.state = state;
    }

    public void performAuthorization(OAuth2Properties config, Callback<String> callback) {
        try {
            this.doAuthorization(config, callback);
        }
        catch (UnsupportedEncodingException ex) {
            callback.onFailure((Exception)ex);
        }
        catch (MalformedURLException ex) {
            callback.onFailure((Exception)ex);
        }
    }

    private String formatScopes(ArrayList<String> scopes) throws UnsupportedEncodingException {
        StringBuilder scopeValue = new StringBuilder();
        String append = "";
        for (String scope : scopes) {
            scopeValue.append(append);
            scopeValue.append(URLEncoder.encode(scope, "UTF-8"));
            append = "+";
        }
        return scopeValue.toString();
    }

    private void doAuthorization(OAuth2Properties config, final Callback<String> callback) throws UnsupportedEncodingException, MalformedURLException {
        URL baseURL = config.getBaseURL();
        URL authzEndpoint = UrlUtils.appendToBaseURL((URL)baseURL, (String)config.getAuthzEndpoint());
        Uri redirectURL = Uri.parse((String)config.getRedirectURL());
        ArrayList<String> scopes = new ArrayList<String>(config.getScopes());
        String clientId = config.getClientId();
        String query = "?scope=%s&redirect_uri=%s&client_id=%s&state=%s&response_type=code";
        query = String.format(query, this.formatScopes(scopes), URLEncoder.encode(redirectURL.toString(), "UTF-8"), clientId, this.state);
        if (config.getAdditionalAuthorizationParams() != null && config.getAdditionalAuthorizationParams().size() > 0) {
            for (Pair<String, String> param : config.getAdditionalAuthorizationParams()) {
                query = query + String.format("&%s=%s", URLEncoder.encode((String)param.first, "UTF-8"), URLEncoder.encode((String)param.second, "UTF-8"));
            }
        }
        URL authURL = new URL(authzEndpoint.toString() + query);
        final OAuthWebViewDialog dialog = OAuthWebViewDialog.newInstance(authURL, redirectURL);
        dialog.setReceiver(new OAuthWebViewDialog.OAuthReceiver(){

            @Override
            public void receiveOAuthCode(String code) {
                dialog.removeReceive();
                dialog.dismiss();
                callback.onSuccess((Object)code);
            }

            @Override
            public void receiveOAuthError(String error) {
                dialog.removeReceive();
                dialog.dismiss();
                callback.onFailure((Exception)new OAuth2AuthorizationException(error));
            }
        });
        dialog.setStyle(16973837, 0);
        dialog.show(this.activity.getFragmentManager(), "TAG");
    }
}

