/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.GsonResponseParser;
import org.jboss.aerogear.android.impl.pipeline.PipeTypes;
import org.jboss.aerogear.android.impl.pipeline.RestRunner;
import org.jboss.aerogear.android.impl.pipeline.RestfulPipeConfiguration;
import org.jboss.aerogear.android.impl.pipeline.paging.WebLink;
import org.jboss.aerogear.android.impl.pipeline.paging.WrappingPagedList;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.impl.reflection.Scan;
import org.jboss.aerogear.android.impl.util.ParseException;
import org.jboss.aerogear.android.impl.util.WebLinkParser;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeType;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;
import org.jboss.aerogear.android.pipeline.paging.PageConfig;
import org.json.JSONObject;

public final class RestAdapter<T>
implements Pipe<T> {
    private static final String TAG = RestAdapter.class.getSimpleName();
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAX_POOL_SIZE = 64;
    private static final int KEEP_ALIVE = 1;
    private static final BlockingQueue<Runnable> WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
    public static final Executor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(5, 64, 1L, TimeUnit.SECONDS, WORK_QUEUE);
    private final Class<T> klass;
    private final URL url;
    private final PipeHandler<T> restRunner;
    private final RequestBuilder<T> requestBuilder;
    private final ResponseParser<T> responseParser;
    private final PageConfig pageConfig;

    public RestAdapter(Class<T> klass, URL absoluteURL) {
        this.restRunner = new RestRunner<T>(klass, absoluteURL);
        this.klass = klass;
        this.url = absoluteURL;
        this.pageConfig = null;
        this.requestBuilder = new GsonRequestBuilder();
        this.responseParser = new GsonResponseParser();
    }

    public RestAdapter(Class<T> klass, URL absoluteURL, RestfulPipeConfiguration config) {
        this.klass = klass;
        this.url = absoluteURL;
        this.pageConfig = config.getPageConfig();
        this.requestBuilder = config.getRequestBuilder();
        this.responseParser = config.getResponseParser();
        this.restRunner = config.getPipeHandler() != null ? config.getPipeHandler() : new RestRunner<T>(klass, absoluteURL, config);
    }

    RestAdapter(Class<T> klass, RestfulPipeConfiguration configuration) {
        this.klass = klass;
        this.url = configuration.getUrl();
        this.pageConfig = configuration.getPageConfig();
        this.requestBuilder = configuration.getRequestBuilder();
        this.responseParser = configuration.getResponseParser();
        this.restRunner = new RestRunner<T>(klass, this.url, configuration);
    }

    @Override
    public PipeType getType() {
        return PipeTypes.REST;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void read(ReadFilter filter, final Callback<List<T>> callback) {
        if (filter == null) {
            filter = new ReadFilter();
        }
        final ReadFilter innerFilter = filter;
        THREAD_POOL_EXECUTOR.execute(new Runnable(){
            List<T> result = null;
            Exception exception = null;

            @Override
            public void run() {
                try {
                    HeaderAndBody response = RestAdapter.this.restRunner.onRawReadWithFilter(innerFilter, RestAdapter.this);
                    this.result = RestAdapter.this.getResponseParser().handleResponse(response, RestAdapter.this.klass);
                    if (RestAdapter.this.pageConfig != null) {
                        this.result = RestAdapter.this.computePagedList(this.result, response, innerFilter.getWhere(), RestAdapter.this);
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    this.exception = e;
                }
                if (this.exception == null) {
                    callback.onSuccess(this.result);
                } else {
                    callback.onFailure(this.exception);
                }
            }
        });
    }

    @Override
    public void read(final Callback<List<T>> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){
            List<T> result = null;
            Exception exception = null;

            @Override
            public void run() {
                try {
                    this.result = RestAdapter.this.getResponseParser().handleResponse(RestAdapter.this.restRunner.onRawRead(RestAdapter.this), RestAdapter.this.klass);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    this.exception = e;
                }
                if (this.exception == null) {
                    callback.onSuccess(this.result);
                } else {
                    callback.onFailure(this.exception);
                }
            }
        });
    }

    @Override
    public void save(final T data, final Callback<T> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Object result = null;
                Exception exception = null;
                try {
                    String recordIdFieldName = Scan.recordIdFieldNameIn(data.getClass());
                    Object idObject = new Property(data.getClass(), recordIdFieldName).getValue(data);
                    String id = idObject == null ? null : idObject.toString();
                    byte[] body = RestAdapter.this.requestBuilder.getBody(data);
                    HeaderAndBody response = RestAdapter.this.restRunner.onRawSave(id, body);
                    result = RestAdapter.this.getResponseParser().handleResponse(response, RestAdapter.this.klass).get(0);
                }
                catch (Exception e) {
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void remove(final String id, final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){
            Exception exception = null;

            @Override
            public void run() {
                try {
                    RestAdapter.this.restRunner.onRemove(id);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                if (this.exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(this.exception);
                }
            }
        });
    }

    @Override
    public PipeHandler<T> getHandler() {
        return this.restRunner;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    @Override
    public RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public ResponseParser<T> getResponseParser() {
        return this.responseParser;
    }

    private List<T> computePagedList(List<T> result, HeaderAndBody httpResponse, JSONObject where, Pipe<T> requestingPipe) {
        ReadFilter previousRead = null;
        ReadFilter nextRead = null;
        if (PageConfig.MetadataLocations.WEB_LINKING.equals(this.pageConfig.getMetadataLocation())) {
            String webLinksRaw = "";
            String relHeader = "rel";
            String nextIdentifier = this.pageConfig.getNextIdentifier();
            String prevIdentifier = this.pageConfig.getPreviousIdentifier();
            try {
                webLinksRaw = this.getWebLinkHeader(httpResponse);
                if (webLinksRaw == null) {
                    return result;
                }
                List<WebLink> webLinksParsed = WebLinkParser.parse(webLinksRaw);
                for (WebLink link : webLinksParsed) {
                    if (nextIdentifier.equals(link.getParameters().get("rel"))) {
                        nextRead = new ReadFilter();
                        nextRead.setLinkUri(new URI(link.getUri()));
                        continue;
                    }
                    if (!prevIdentifier.equals(link.getParameters().get("rel"))) continue;
                    previousRead = new ReadFilter();
                    previousRead.setLinkUri(new URI(link.getUri()));
                }
            }
            catch (URISyntaxException ex) {
                Log.e((String)TAG, (String)(webLinksRaw + " did not contain a valid context URI"), (Throwable)ex);
                throw new RuntimeException(ex);
            }
            catch (ParseException ex) {
                Log.e((String)TAG, (String)(webLinksRaw + " could not be parsed as a web link header"), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        } else if (this.pageConfig.getMetadataLocation().equals(PageConfig.MetadataLocations.HEADERS)) {
            nextRead = this.pageConfig.getPageParameterExtractor().getNextFilter(httpResponse, this.pageConfig);
            previousRead = this.pageConfig.getPageParameterExtractor().getPreviousFilter(httpResponse, this.pageConfig);
        } else if (this.pageConfig.getMetadataLocation().equals(PageConfig.MetadataLocations.BODY)) {
            nextRead = this.pageConfig.getPageParameterExtractor().getNextFilter(httpResponse, this.pageConfig);
            previousRead = this.pageConfig.getPageParameterExtractor().getPreviousFilter(httpResponse, this.pageConfig);
        } else {
            throw new IllegalStateException("Not supported");
        }
        if (nextRead != null) {
            nextRead.setWhere(where);
        }
        if (previousRead != null) {
            previousRead.setWhere(where);
        }
        return new WrappingPagedList<T>(requestingPipe, result, nextRead, previousRead);
    }

    private String getWebLinkHeader(HeaderAndBody httpResponse) {
        String linkHeaderName = "Link";
        Object header = httpResponse.getHeader(linkHeaderName);
        if (header != null) {
            return header.toString();
        }
        return null;
    }
}

