/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.util.Log;
import android.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.code.ModuleFields;
import org.jboss.aerogear.android.code.PipeModule;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.core.HttpProviderFactory;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.GsonResponseParser;
import org.jboss.aerogear.android.impl.pipeline.RestfulPipeConfiguration;
import org.jboss.aerogear.android.impl.pipeline.paging.DefaultParameterProvider;
import org.jboss.aerogear.android.impl.pipeline.paging.URIBodyPageParser;
import org.jboss.aerogear.android.impl.pipeline.paging.URIPageHeaderParser;
import org.jboss.aerogear.android.impl.util.ClassUtils;
import org.jboss.aerogear.android.impl.util.UrlUtils;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;
import org.jboss.aerogear.android.pipeline.paging.PageConfig;
import org.jboss.aerogear.android.pipeline.paging.ParameterProvider;

public class RestRunner<T>
implements PipeHandler<T> {
    private final PageConfig pageConfig;
    private static final String TAG = RestRunner.class.getSimpleName();
    private final RequestBuilder<T> requestBuilder;
    private final ParameterProvider parameterProvider;
    private final Class<T> klass;
    private final Class<T[]> arrayKlass;
    private final URL baseURL;
    private final Provider<HttpProvider> httpProviderFactory = new HttpProviderFactory();
    private final Integer timeout;
    private final ResponseParser<T> responseParser;
    private Set<PipeModule> modules = new HashSet<PipeModule>();

    public RestRunner(Class<T> klass, URL baseURL) {
        this.klass = klass;
        this.arrayKlass = ClassUtils.asArrayClass(klass);
        this.baseURL = baseURL;
        this.requestBuilder = new GsonRequestBuilder();
        this.pageConfig = null;
        this.parameterProvider = new DefaultParameterProvider();
        this.timeout = 60000;
        this.responseParser = new GsonResponseParser();
    }

    RestRunner(Class<T> klass, URL baseURL, RestfulPipeConfiguration config) {
        this.klass = klass;
        this.arrayKlass = ClassUtils.asArrayClass(klass);
        this.baseURL = baseURL;
        this.timeout = config.getTimeout();
        this.requestBuilder = config.getRequestBuilder() != null ? config.getRequestBuilder() : new GsonRequestBuilder();
        this.responseParser = config.getResponseParser() != null ? config.getResponseParser() : new GsonResponseParser();
        if (config.getPageConfig() != null) {
            this.pageConfig = config.getPageConfig();
            this.parameterProvider = this.pageConfig.getParameterProvider() != null ? this.pageConfig.getParameterProvider() : new DefaultParameterProvider();
            if (this.pageConfig.getPageParameterExtractor() == null) {
                if (PageConfig.MetadataLocations.BODY.equals(this.pageConfig.getMetadataLocation())) {
                    this.pageConfig.setPageParameterExtractor(new URIBodyPageParser(baseURL));
                } else if (PageConfig.MetadataLocations.HEADERS.equals(this.pageConfig.getMetadataLocation())) {
                    this.pageConfig.setPageParameterExtractor(new URIPageHeaderParser(baseURL));
                }
            }
        } else {
            this.pageConfig = null;
            this.parameterProvider = new DefaultParameterProvider();
        }
        this.modules.addAll(config.getModules());
    }

    @Override
    public void onRemove(String id) {
        HttpProvider httpProvider = this.getHttpProvider();
        httpProvider.delete(id);
    }

    private URL addAuthorization(List<Pair<String, String>> queryParameters, URL baseURL) {
        StringBuilder queryBuilder = new StringBuilder();
        String amp = "";
        for (Pair<String, String> parameter : queryParameters) {
            try {
                queryBuilder.append(amp).append(URLEncoder.encode((String)parameter.first, "UTF-8")).append("=").append(URLEncoder.encode((String)parameter.second, "UTF-8"));
                amp = "&";
            }
            catch (UnsupportedEncodingException ex) {
                Log.e((String)TAG, (String)"UTF-8 encoding is not supported.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return this.appendQuery(queryBuilder.toString(), baseURL);
    }

    private void addAuthHeaders(HttpProvider httpProvider, ModuleFields fields) {
        List<Pair<String, String>> authHeaders = fields.getHeaders();
        for (Pair<String, String> header : authHeaders) {
            httpProvider.setDefaultHeader((String)header.first, (String)header.second);
        }
    }

    private HttpProvider getHttpProvider() {
        return this.getHttpProvider(URI.create(""));
    }

    private HttpProvider getHttpProvider(URI relativeUri) {
        ModuleFields fields = this.loadAuth(relativeUri, "GET");
        String queryString = relativeUri == null || relativeUri.getQuery() == null ? "" : relativeUri.getQuery().toString();
        URL mergedURL = UrlUtils.appendToBaseURL(this.baseURL, relativeUri.getPath());
        URL authorizedURL = this.addAuthorization(fields.getQueryParameters(), UrlUtils.appendQueryToBaseURL(mergedURL, queryString));
        HttpProvider httpProvider = (HttpProvider)this.httpProviderFactory.get(new Object[]{authorizedURL, this.timeout});
        httpProvider.setDefaultHeader("Content-TYpe", this.requestBuilder.getContentType());
        this.addAuthHeaders(httpProvider, fields);
        return httpProvider;
    }

    private ModuleFields loadAuth(URI relativeURI, String httpMethod) {
        ModuleFields authFields = new ModuleFields();
        for (PipeModule module : this.modules) {
            ModuleFields moduleFields = module.loadModule(relativeURI, httpMethod, new byte[0]);
            if (!moduleFields.getHeaders().isEmpty()) {
                for (Pair<String, String> header : moduleFields.getHeaders()) {
                    authFields.addHeader((String)header.first, (String)header.second);
                }
            }
            if (moduleFields.getQueryParameters().isEmpty()) continue;
            for (Pair<String, String> header : moduleFields.getQueryParameters()) {
                authFields.addQueryParameter((String)header.first, (String)header.second);
            }
        }
        return authFields;
    }

    private URL appendQuery(String query, URL baseURL) {
        try {
            URI baseURI = baseURL.toURI();
            String baseQuery = baseURI.getQuery();
            if (baseQuery == null || baseQuery.isEmpty()) {
                baseQuery = query;
            } else if (query != null && !query.isEmpty()) {
                baseQuery = baseQuery + "&" + query;
            }
            if (baseQuery.isEmpty()) {
                baseQuery = null;
            }
            return new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), baseURI.getPath(), baseQuery, baseURI.getFragment()).toURL();
        }
        catch (MalformedURLException ex) {
            Log.e((String)TAG, (String)("The URL could not be created from " + baseURL.toString()), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (URISyntaxException ex) {
            Log.e((String)TAG, (String)("Error turning " + query + " into URI query."), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public HeaderAndBody onRawRead(Pipe<T> requestingPipe) {
        return this.onRawReadWithFilter(new ReadFilter(), requestingPipe);
    }

    @Override
    public HeaderAndBody onRawReadWithFilter(ReadFilter filter, Pipe<T> requestingPipe) {
        if (filter == null) {
            filter = new ReadFilter();
        }
        HttpProvider httpProvider = filter.getLinkUri() == null ? this.getHttpProvider(this.parameterProvider.getParameters(filter)) : this.getHttpProvider(filter.getLinkUri());
        return this.runHttpGet(httpProvider);
    }

    private HeaderAndBody runHttpGet(HttpProvider httpProvider) {
        try {
            HeaderAndBody httpResponse = httpProvider.get();
            return httpResponse;
        }
        catch (HttpException exception) {
            for (PipeModule module : this.modules) {
                if (!module.handleError(exception)) continue;
                HeaderAndBody httpResponse = httpProvider.get();
                return httpResponse;
            }
            throw exception;
        }
    }

    @Override
    public HeaderAndBody onRawSave(String id, byte[] item) {
        HttpProvider httpProvider = this.getHttpProvider();
        HeaderAndBody result = id == null || id.length() == 0 ? httpProvider.post(item) : httpProvider.put(id, item);
        return result;
    }
}

