/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipeline;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.ConfigurationProvider;
import org.jboss.aerogear.android.impl.pipeline.LoaderAdapter;
import org.jboss.aerogear.android.impl.pipeline.RestfulPipeConfiguration;
import org.jboss.aerogear.android.impl.pipeline.SupportLoaderAdapter;
import org.jboss.aerogear.android.pipeline.LoaderPipe;
import org.jboss.aerogear.android.pipeline.OnPipeCreatedListener;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeConfiguration;
import org.jboss.aerogear.android.pipeline.RestfulPipeConfigurationProvider;

public class PipeManager {
    private static Map<String, Pipe<?>> pipes = new HashMap();
    private static Map<Class<? extends PipeConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnPipeCreatedListener onPipeCreatedListener = new OnPipeCreatedListener(){

        @Override
        public void onPipeCreated(PipeConfiguration<?> configuration, Pipe<?> pipe) {
            pipes.put(configuration.getName(), pipe);
        }
    };
    private static final Multimap<String, Integer> loaderIdsForNamed;

    private PipeManager() {
    }

    public static <CFG extends PipeConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends PipeConfiguration<CFG>> CFG config(String name, Class<CFG> pipeConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(pipeConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((PipeConfiguration)provider.newConfiguration()).setName(name).addOnPipeCreatedListener(onPipeCreatedListener);
    }

    public static Pipe getPipe(String name) {
        return pipes.get(name);
    }

    public static LoaderPipe get(String name, Activity activity) {
        Pipe<?> pipe = pipes.get(name);
        LoaderAdapter adapter = new LoaderAdapter(activity, pipe, name);
        adapter.setLoaderIds(loaderIdsForNamed);
        return adapter;
    }

    public static LoaderPipe get(String name, Fragment fragment, Context applicationContext) {
        Pipe<?> pipe = pipes.get(name);
        LoaderAdapter adapter = new LoaderAdapter(fragment, applicationContext, pipe, name);
        adapter.setLoaderIds(loaderIdsForNamed);
        return adapter;
    }

    public static LoaderPipe get(String name, FragmentActivity activity) {
        Pipe<?> pipe = pipes.get(name);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(activity, pipe, name);
        adapter.setLoaderIds(loaderIdsForNamed);
        return adapter;
    }

    public static LoaderPipe get(String name, android.support.v4.app.Fragment fragment, Context applicationContext) {
        Pipe<?> pipe = pipes.get(name);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(fragment, applicationContext, pipe, name);
        adapter.setLoaderIds(loaderIdsForNamed);
        return adapter;
    }

    static {
        RestfulPipeConfigurationProvider configurationProvider = new RestfulPipeConfigurationProvider();
        PipeManager.registerConfigurationProvider(RestfulPipeConfiguration.class, configurationProvider);
        loaderIdsForNamed = HashMultimap.create();
    }
}

