/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HttpException
extends RuntimeException {
    private static final String DEFAULT_MESSAGE = "The server returned the error code %d.";
    private final byte[] data;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final int statusCode;

    public HttpException(byte[] data, int statusCode) {
        this(data, statusCode, String.format(DEFAULT_MESSAGE, statusCode), new HashMap<String, String>());
    }

    public HttpException(byte[] data, int statusCode, Map<String, String> headers) {
        this(data, statusCode, String.format(DEFAULT_MESSAGE, statusCode), headers);
    }

    public HttpException(byte[] data, int statusCode, String message) {
        this(data, statusCode, message, new HashMap<String, String>());
    }

    public HttpException(byte[] data, int statusCode, String message, Map<String, String> headers) {
        super(message);
        this.data = data;
        this.statusCode = statusCode;
        this.headers.putAll(headers);
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }
}

