/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.http;

import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.util.UrlUtils;

public final class HttpRestProvider
implements HttpProvider {
    private static final String TAG = HttpRestProvider.class.getSimpleName();
    private final URL url;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private final Integer timeout;
    private static final CookieManager cm = new CookieManager();
    private final Provider<HttpURLConnection> connectionPreparer = new Provider<HttpURLConnection>(){

        public HttpURLConnection get(Object ... in) {
            HttpURLConnection urlConnection;
            String id = null;
            if (in != null) {
                id = (String)in[0];
            }
            URL resourceURL = HttpRestProvider.this.url;
            if (id != null) {
                resourceURL = UrlUtils.appendToBaseURL(HttpRestProvider.this.url, id);
            }
            try {
                urlConnection = (HttpURLConnection)resourceURL.openConnection();
            }
            catch (IOException ex) {
                Log.e((String)TAG, (String)String.format("Failed to open %s", resourceURL.toString()), (Throwable)ex);
                throw new RuntimeException(ex);
            }
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            for (Map.Entry entry : HttpRestProvider.this.defaultHeaders.entrySet()) {
                urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return urlConnection;
        }
    };

    public HttpRestProvider(URL url) {
        this.url = url;
        this.timeout = 0;
    }

    public HttpRestProvider(URL url, Integer timeout) {
        this.url = url;
        this.timeout = timeout;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public HeaderAndBody get() throws HttpException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.prepareConnection();
            HeaderAndBody headerAndBody = this.getHeaderAndBody(urlConnection);
            return headerAndBody;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error on GET of " + this.url), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public HeaderAndBody post(String data) throws RuntimeException {
        return this.post(data.getBytes());
    }

    @Override
    public HeaderAndBody post(byte[] data) throws RuntimeException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.prepareConnection();
            urlConnection.setRequestMethod("POST");
            this.addBodyRequest(urlConnection, data);
            HeaderAndBody headerAndBody = this.getHeaderAndBody(urlConnection);
            return headerAndBody;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error on POST of " + this.url), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public HeaderAndBody put(String id, String data) throws RuntimeException {
        return this.put(id, data.getBytes());
    }

    @Override
    public HeaderAndBody put(String id, byte[] data) throws RuntimeException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.prepareConnection(id);
            urlConnection.setRequestMethod("PUT");
            this.addBodyRequest(urlConnection, data);
            HeaderAndBody headerAndBody = this.getHeaderAndBody(urlConnection);
            return headerAndBody;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error on PUT of " + this.url), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public HeaderAndBody delete(String id) throws RuntimeException {
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = this.prepareConnection(id);
            urlConnection.setRequestMethod("DELETE");
            HeaderAndBody headerAndBody = this.getHeaderAndBody(urlConnection);
            return headerAndBody;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error on DELETE of " + this.url), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private void addBodyRequest(HttpURLConnection urlConnection, byte[] data) throws IOException {
        urlConnection.setDoOutput(true);
        if (data != null) {
            BufferedOutputStream out = new BufferedOutputStream(urlConnection.getOutputStream());
            ((OutputStream)out).write(data);
            ((OutputStream)out).flush();
        }
    }

    private HttpURLConnection prepareConnection() throws IOException {
        return this.prepareConnection(null);
    }

    private HttpURLConnection prepareConnection(String id) {
        HttpURLConnection connection = (HttpURLConnection)this.connectionPreparer.get(new Object[]{id});
        connection.setReadTimeout(this.timeout);
        connection.setConnectTimeout(this.timeout);
        return connection;
    }

    @Override
    public void setDefaultHeader(String headerName, String headerValue) {
        this.defaultHeaders.put(headerName, headerValue);
    }

    private HeaderAndBody getHeaderAndBody(HttpURLConnection urlConnection) throws IOException {
        byte[] responseData;
        int statusCode = urlConnection.getResponseCode();
        switch (statusCode) {
            case 200: 
            case 201: {
                BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                responseData = this.readBytes(in);
                break;
            }
            case 204: {
                responseData = new byte[]{};
                break;
            }
            default: {
                BufferedInputStream err = new BufferedInputStream(urlConnection.getErrorStream());
                byte[] errData = this.readBytes(err);
                Map<String, List<String>> errorListHeaders = urlConnection.getHeaderFields();
                HashMap<String, String> errorHeaders = new HashMap<String, String>();
                for (String header : errorListHeaders.keySet()) {
                    String comma = "";
                    StringBuilder errorHeaderBuilder = new StringBuilder();
                    for (String errorHeader : errorListHeaders.get(header)) {
                        errorHeaderBuilder.append(comma).append(errorHeader);
                        comma = ",";
                    }
                    errorHeaders.put(header, errorHeaderBuilder.toString());
                }
                throw new HttpException(errData, statusCode, errorHeaders);
            }
        }
        Map<String, List<String>> headers = urlConnection.getHeaderFields();
        HeaderAndBody result = new HeaderAndBody(responseData, new HashMap<String, Object>(headers.size()));
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            result.setHeader(header.getKey(), TextUtils.join((CharSequence)",", (Iterable)header.getValue()));
        }
        return result;
    }

    private byte[] readBytes(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        while ((len = inputStream.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    static {
        CookieHandler.setDefault(cm);
    }
}

