/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.pipeline.loader.support.AbstractSupportPipeLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportReadLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportRemoveLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportSaveLoader;
import org.jboss.aerogear.android.impl.reflection.Scan;
import org.jboss.aerogear.android.pipeline.AbstractActivityCallback;
import org.jboss.aerogear.android.pipeline.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipeline.LoaderPipe;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeType;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;
import org.jboss.aerogear.android.pipeline.support.AbstractFragmentActivityCallback;
import org.jboss.aerogear.android.pipeline.support.AbstractSupportFragmentCallback;

public class SupportLoaderAdapter<T>
implements LoaderPipe<T>,
LoaderManager.LoaderCallbacks<HeaderAndBody> {
    private static final String TAG = SupportLoaderAdapter.class.getSimpleName();
    private Multimap<String, Integer> idsForNamedPipes;
    private final Fragment fragment;
    private final FragmentActivity activity;
    private final Handler handler;
    private final Context applicationContext;
    private final Pipe<T> pipe;
    private final LoaderManager manager;
    private final RequestBuilder<T> requestBuilder;
    private final ResponseParser<T> responseParser;
    private final String name;

    public SupportLoaderAdapter(Fragment fragment, Context applicationContext, Pipe<T> pipe, String name) {
        this.pipe = pipe;
        this.manager = fragment.getLoaderManager();
        this.requestBuilder = pipe.getRequestBuilder();
        this.applicationContext = applicationContext;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.activity = null;
        this.fragment = fragment;
        this.responseParser = pipe.getResponseParser();
    }

    public SupportLoaderAdapter(FragmentActivity activity, Pipe<T> pipe, String name) {
        this.pipe = pipe;
        this.requestBuilder = pipe.getRequestBuilder();
        this.manager = activity.getSupportLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.activity = activity;
        this.fragment = null;
        this.responseParser = pipe.getResponseParser();
    }

    @Override
    public PipeType getType() {
        return this.pipe.getType();
    }

    @Override
    public URL getUrl() {
        return this.pipe.getUrl();
    }

    @Override
    public void read(Callback<List<T>> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", null);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void read(ReadFilter filter, Callback<List<T>> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, filter, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", (Serializable)filter);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void save(T item, Callback<T> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, item, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM", (Serializable)this.requestBuilder.getBody(item));
        bundle.putString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.SAVE_ID", Scan.findIdValueIn(item));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.SAVE));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void remove(String toRemoveId, Callback<Void> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, toRemoveId, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", (Serializable)((Object)toRemoveId));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.REMOVE));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public PipeHandler<T> getHandler() {
        return this.pipe.getHandler();
    }

    public Loader<HeaderAndBody> onCreateLoader(int id, Bundle bundle) {
        this.idsForNamedPipes.put((Object)this.name, (Object)id);
        Methods method = (Methods)((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD"));
        Callback callback = (Callback)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK");
        this.verifyCallback(callback);
        AbstractSupportPipeLoader loader = null;
        switch (method) {
            case READ: {
                ReadFilter filter = (ReadFilter)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER");
                loader = new SupportReadLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), filter, this);
                break;
            }
            case REMOVE: {
                String toRemove = (String)Objects.firstNonNull((Object)bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID"), (Object)"-1");
                loader = new SupportRemoveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), toRemove);
                break;
            }
            case SAVE: {
                byte[] data = bundle.getByteArray("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM");
                String dataId = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.SAVE_ID");
                loader = new SupportSaveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), data, dataId);
            }
        }
        return loader;
    }

    @Override
    public RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public ResponseParser<T> getResponseParser() {
        return this.responseParser;
    }

    @Override
    public Class<T> getKlass() {
        return this.pipe.getKlass();
    }

    public void onLoadFinished(Loader<HeaderAndBody> loader, HeaderAndBody data) {
        if (!(loader instanceof AbstractSupportPipeLoader)) {
            Log.e((String)TAG, (String)"Adapter is listening to loaders which it doesn't support");
            throw new IllegalStateException("Adapter is listening to loaders which it doesn't support");
        }
        AbstractSupportPipeLoader supportLoader = (AbstractSupportPipeLoader)loader;
        Object object = null;
        if (!supportLoader.hasException() && data != null && data.getBody() != null) {
            object = this.extractObject(data, supportLoader);
        }
        this.handler.post(new CallbackHandler(this, supportLoader, object));
    }

    public void onLoaderReset(Loader<HeaderAndBody> loader) {
    }

    @Override
    public void reset() {
        for (Integer id : this.idsForNamedPipes.get((Object)this.name)) {
            Loader loader = this.manager.getLoader(id.intValue());
            if (loader == null) continue;
            this.manager.destroyLoader(id.intValue());
        }
        this.idsForNamedPipes.removeAll((Object)this.name);
    }

    @Override
    public void setLoaderIds(Multimap<String, Integer> idsForNamedPipes) {
        this.idsForNamedPipes = idsForNamedPipes;
    }

    private void fragmentSuccess(Callback<T> typelessCallback, Object data) {
        AbstractSupportFragmentCallback callback = (AbstractSupportFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onSuccess(data);
        callback.setFragment(null);
    }

    private void fragmentFailure(Callback<T> typelessCallback, Exception exception) {
        AbstractSupportFragmentCallback callback = (AbstractSupportFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onFailure(exception);
        callback.setFragment(null);
    }

    private void activitySuccess(Callback<T> typelessCallback, Object data) {
        AbstractFragmentActivityCallback callback = (AbstractFragmentActivityCallback)typelessCallback;
        callback.setFragmentActivity(this.activity);
        callback.onSuccess(data);
        callback.setFragmentActivity(null);
    }

    private void activityFailure(Callback<T> typelessCallback, Exception exception) {
        AbstractFragmentActivityCallback callback = (AbstractFragmentActivityCallback)typelessCallback;
        callback.setFragmentActivity(this.activity);
        callback.onFailure(exception);
        callback.setFragmentActivity(null);
    }

    private Object extractObject(HeaderAndBody data, AbstractSupportPipeLoader<HeaderAndBody> supportLoader) {
        List<T> results = this.responseParser.handleResponse(data, this.getKlass());
        if (results == null || results.size() == 0) {
            return results;
        }
        if (supportLoader instanceof SupportSaveLoader) {
            return results.get(0);
        }
        return results;
    }

    private void verifyCallback(Callback<List<T>> callback) {
        if (callback instanceof AbstractFragmentActivityCallback) {
            if (this.activity == null) {
                throw new IllegalStateException("An AbstractFragmentActivityCallback was supplied, but there is no Activity.");
            }
        } else if (callback instanceof AbstractSupportFragmentCallback) {
            if (this.fragment == null) {
                throw new IllegalStateException("An AbstractSupportFragmentCallback was supplied, but there is no Fragment.");
            }
        } else {
            if (callback instanceof AbstractActivityCallback) {
                throw new IllegalStateException("An AbstractActivityCallback was supplied, but this is the support Loader.");
            }
            if (callback instanceof AbstractFragmentCallback) {
                throw new IllegalStateException("An AbstractFragmentCallback was supplied, but this is the support Loader.");
            }
        }
    }

    static class CallbackHandler<T>
    implements Runnable {
        private final SupportLoaderAdapter<T> adapter;
        private final AbstractSupportPipeLoader<T> modernLoader;
        private final Object data;

        public CallbackHandler(SupportLoaderAdapter<T> adapter, AbstractSupportPipeLoader loader, Object data) {
            this.adapter = adapter;
            this.modernLoader = loader;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.modernLoader.hasException()) {
                Exception exception = this.modernLoader.getException();
                Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                if (this.modernLoader.getCallback() instanceof AbstractSupportFragmentCallback) {
                    ((SupportLoaderAdapter)this.adapter).fragmentFailure(this.modernLoader.getCallback(), exception);
                } else if (this.modernLoader.getCallback() instanceof AbstractFragmentActivityCallback) {
                    ((SupportLoaderAdapter)this.adapter).activityFailure(this.modernLoader.getCallback(), exception);
                } else {
                    this.modernLoader.getCallback().onFailure(exception);
                }
            } else if (this.modernLoader.getCallback() instanceof AbstractSupportFragmentCallback) {
                ((SupportLoaderAdapter)this.adapter).fragmentSuccess(this.modernLoader.getCallback(), this.data);
            } else if (this.modernLoader.getCallback() instanceof AbstractFragmentActivityCallback) {
                ((SupportLoaderAdapter)this.adapter).activitySuccess(this.modernLoader.getCallback(), this.data);
            } else {
                this.modernLoader.getCallback().onSuccess(this.data);
            }
        }
    }

    private static enum Methods {
        READ,
        SAVE,
        REMOVE;

    }
}

