/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.aerogear.android.core.Config;
import org.jboss.aerogear.android.pipe.OnPipeCreatedListener;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.RequestBuilder;
import org.jboss.aerogear.android.pipe.ResponseParser;
import org.jboss.aerogear.android.pipe.module.PipeModule;
import org.jboss.aerogear.android.pipe.paging.PageConfig;

public abstract class PipeConfiguration<CONFIGURATION extends PipeConfiguration<CONFIGURATION>>
implements Config<CONFIGURATION> {
    private String name;
    private Collection<OnPipeCreatedListener> listeners = new HashSet<OnPipeCreatedListener>();

    public String getName() {
        return this.name;
    }

    public CONFIGURATION setName(String name) {
        this.name = name;
        return (CONFIGURATION)this;
    }

    public Collection<OnPipeCreatedListener> getOnPipeCreatedListeners() {
        return this.listeners;
    }

    public CONFIGURATION addOnPipeCreatedListener(OnPipeCreatedListener listener) {
        this.listeners.add(listener);
        return (CONFIGURATION)this;
    }

    public CONFIGURATION setOnPipeCreatedListeners(Collection<OnPipeCreatedListener> listeners) {
        listeners.addAll(listeners);
        return (CONFIGURATION)this;
    }

    public final <DATA> Pipe<DATA> forClass(Class<DATA> aClass) {
        Pipe<DATA> newPipe = this.buildPipeForClass(aClass);
        for (OnPipeCreatedListener listener : this.getOnPipeCreatedListeners()) {
            listener.onPipeCreated(this, newPipe);
        }
        return newPipe;
    }

    protected abstract <DATA> Pipe<DATA> buildPipeForClass(Class<DATA> var1);

    public abstract CONFIGURATION withUrl(URL var1);

    public abstract CONFIGURATION module(PipeModule var1);

    public abstract List<PipeModule> getModules();

    public abstract CONFIGURATION timeout(Integer var1);

    public abstract CONFIGURATION pageConfig(PageConfig var1);

    public abstract CONFIGURATION requestBuilder(RequestBuilder var1);

    public abstract CONFIGURATION responseParser(ResponseParser var1);
}

