/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.rest;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aerogear.android.core.Config;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.PipeConfiguration;
import org.jboss.aerogear.android.pipe.PipeHandler;
import org.jboss.aerogear.android.pipe.RequestBuilder;
import org.jboss.aerogear.android.pipe.ResponseParser;
import org.jboss.aerogear.android.pipe.module.PipeModule;
import org.jboss.aerogear.android.pipe.paging.PageConfig;
import org.jboss.aerogear.android.pipe.rest.RestAdapter;
import org.jboss.aerogear.android.pipe.rest.gson.GsonRequestBuilder;
import org.jboss.aerogear.android.pipe.rest.gson.GsonResponseParser;

public class RestfulPipeConfiguration
extends PipeConfiguration<RestfulPipeConfiguration>
implements Config<RestfulPipeConfiguration> {
    private URL url;
    private String name;
    private Integer timeout = 60000;
    private final List<PipeModule> modules = new ArrayList<PipeModule>();
    private PageConfig pageConfig;
    private RequestBuilder requestBuilder = new GsonRequestBuilder();
    private ResponseParser responseParser = new GsonResponseParser();
    private PipeHandler handler = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RestfulPipeConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    protected <DATA> Pipe<DATA> buildPipeForClass(Class<DATA> aClass) {
        if (this.url == null) {
            throw new IllegalStateException("url may not be null");
        }
        return new RestAdapter<DATA>(aClass, this);
    }

    @Override
    public RestfulPipeConfiguration withUrl(URL url) {
        this.url = url;
        return this;
    }

    @Override
    public RestfulPipeConfiguration module(PipeModule module) {
        this.modules.add(module);
        return this;
    }

    @Override
    public List<PipeModule> getModules() {
        return new ArrayList<PipeModule>(this.modules);
    }

    @Override
    public RestfulPipeConfiguration timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public RestfulPipeConfiguration pageConfig(PageConfig pageConfig) {
        this.pageConfig = pageConfig;
        return this;
    }

    @Override
    public RestfulPipeConfiguration requestBuilder(RequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
        return this;
    }

    @Override
    public RestfulPipeConfiguration responseParser(ResponseParser responseParser) {
        this.responseParser = responseParser;
        return this;
    }

    public RestfulPipeConfiguration pipeHandler(PipeHandler handler) {
        this.handler = handler;
        return this;
    }

    public PipeHandler getPipeHandler() {
        return this.handler;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public RequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public ResponseParser getResponseParser() {
        return this.responseParser;
    }

    public PageConfig getPageConfig() {
        return this.pageConfig;
    }

    public URL getUrl() {
        return this.url;
    }
}

