/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.pipe.LoaderPipe;
import org.jboss.aerogear.android.pipe.OnPipeCreatedListener;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.PipeConfiguration;
import org.jboss.aerogear.android.pipe.loader.LoaderAdapter;
import org.jboss.aerogear.android.pipe.rest.RestfulPipeConfiguration;
import org.jboss.aerogear.android.pipe.rest.RestfulPipeConfigurationProvider;

public class PipeManager {
    private static Map<String, Pipe<?>> pipes = new HashMap();
    private static Map<Class<? extends PipeConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnPipeCreatedListener onPipeCreatedListener = new OnPipeCreatedListener(){

        @Override
        public void onPipeCreated(PipeConfiguration<?> configuration, Pipe<?> pipe) {
            pipes.put(configuration.getName(), pipe);
        }
    };
    private static final Map<String, List<Integer>> loaderIdsForNamed;

    private PipeManager() {
    }

    public static <CFG extends PipeConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends PipeConfiguration<CFG>> CFG config(String name, Class<CFG> pipeConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(pipeConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((PipeConfiguration)provider.newConfiguration()).setName(name).addOnPipeCreatedListener(onPipeCreatedListener);
    }

    public static Pipe getPipe(String name) {
        return pipes.get(name);
    }

    public static LoaderPipe getPipe(String name, Activity activity) {
        Pipe<?> pipe = pipes.get(name);
        LoaderAdapter adapter = new LoaderAdapter(activity, pipe, name);
        adapter.setLoaderIds(loaderIdsForNamed);
        return adapter;
    }

    public static LoaderPipe getPipe(String name, Fragment fragment, Context applicationContext) {
        Pipe<?> pipe = pipes.get(name);
        LoaderAdapter adapter = new LoaderAdapter(fragment, applicationContext, pipe, name);
        adapter.setLoaderIds(loaderIdsForNamed);
        return adapter;
    }

    static {
        RestfulPipeConfigurationProvider configurationProvider = new RestfulPipeConfigurationProvider();
        PipeManager.registerConfigurationProvider(RestfulPipeConfiguration.class, configurationProvider);
        loaderIdsForNamed = new HashMap<String, List<Integer>>();
    }
}

