/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.loader;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.ReadFilter;
import org.jboss.aerogear.android.core.reflection.Scan;
import org.jboss.aerogear.android.pipe.LoaderPipe;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.PipeHandler;
import org.jboss.aerogear.android.pipe.RequestBuilder;
import org.jboss.aerogear.android.pipe.ResponseParser;
import org.jboss.aerogear.android.pipe.callback.AbstractActivityCallback;
import org.jboss.aerogear.android.pipe.callback.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.loader.AbstractPipeLoader;
import org.jboss.aerogear.android.pipe.loader.IdReadLoader;
import org.jboss.aerogear.android.pipe.loader.ReadLoader;
import org.jboss.aerogear.android.pipe.loader.RemoveLoader;
import org.jboss.aerogear.android.pipe.loader.SaveLoader;

@TargetApi(value=14)
public class LoaderAdapter<T>
implements LoaderPipe<T>,
LoaderManager.LoaderCallbacks<HeaderAndBody> {
    private static final String TAG = LoaderAdapter.class.getSimpleName();
    private final Handler handler;
    private Map<String, List<Integer>> idsForNamedPipes;
    private final Context applicationContext;
    private Fragment fragment;
    private Activity activity;
    private final Pipe<T> pipe;
    private final LoaderManager manager;
    private final String name;
    private final RequestBuilder<T> requestBuilder;
    private final ResponseParser<T> responseParser;

    public LoaderAdapter(Activity activity, Pipe<T> pipe, String name) {
        this.pipe = pipe;
        this.requestBuilder = pipe.getRequestBuilder();
        this.responseParser = pipe.getResponseParser();
        this.manager = activity.getLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.activity = activity;
    }

    public LoaderAdapter(Fragment fragment, Context applicationContext, Pipe<T> pipe, String name) {
        this.pipe = pipe;
        this.manager = fragment.getLoaderManager();
        this.requestBuilder = pipe.getRequestBuilder();
        this.responseParser = pipe.getResponseParser();
        this.applicationContext = applicationContext;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.fragment = fragment;
    }

    @Override
    public URL getUrl() {
        return this.pipe.getUrl();
    }

    @Override
    public void read(String idx, Callback<T> callback) {
        ReadFilter filter = new ReadFilter();
        filter.setLinkUri(URI.create(idx));
        int id = Arrays.hashCode(new Object[]{this.name, filter, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", (Serializable)filter);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ_ID));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void read(Callback<List<T>> callback) {
        int id = Arrays.hashCode(new Object[]{this.name, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", null);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void read(ReadFilter filter, Callback<List<T>> callback) {
        int id = Arrays.hashCode(new Object[]{this.name, filter, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", (Serializable)filter);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void save(T item, Callback<T> callback) {
        int id = Arrays.hashCode(new Object[]{this.name, item, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM", (Serializable)this.requestBuilder.getBody(item));
        bundle.putString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.SAVE_ID", Scan.findIdValueIn(item));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.SAVE));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void remove(String toRemoveId, Callback<Void> callback) {
        int id = Arrays.hashCode(new Object[]{this.name, toRemoveId, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", (Serializable)((Object)toRemoveId));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.REMOVE));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public PipeHandler<T> getHandler() {
        return this.pipe.getHandler();
    }

    @Override
    public RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public ResponseParser<T> getResponseParser() {
        return this.responseParser;
    }

    @Override
    public Class<T> getKlass() {
        return this.pipe.getKlass();
    }

    public Loader<HeaderAndBody> onCreateLoader(int id, Bundle bundle) {
        this.addId(this.name, id);
        Methods method = (Methods)((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD"));
        Callback callback = (Callback)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK");
        this.verifyCallback(callback);
        AbstractPipeLoader loader = null;
        switch (method) {
            case READ: {
                ReadFilter filter = (ReadFilter)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER");
                loader = new ReadLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), filter, this);
                break;
            }
            case READ_ID: {
                ReadFilter filter = (ReadFilter)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER");
                loader = new IdReadLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), filter, this);
                break;
            }
            case REMOVE: {
                String toRemove = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", "-1");
                loader = new RemoveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), toRemove);
                break;
            }
            case SAVE: {
                byte[] data = bundle.getByteArray("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM");
                String dataId = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.SAVE_ID");
                loader = new SaveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), data, dataId);
            }
        }
        return loader;
    }

    public void onLoadFinished(Loader<HeaderAndBody> loader, HeaderAndBody data) {
        if (!(loader instanceof AbstractPipeLoader)) {
            Log.e((String)TAG, (String)"Adapter is listening to loaders which it doesn't support");
            throw new IllegalStateException("Adapter is listening to loaders which it doesn't support");
        }
        AbstractPipeLoader modernLoader = (AbstractPipeLoader)loader;
        Object object = null;
        if (!modernLoader.hasException() && data != null && data.getBody() != null) {
            object = this.extractObject(data, modernLoader);
        }
        this.handler.post(new CallbackHandler(this, modernLoader, object));
    }

    public void onLoaderReset(Loader<HeaderAndBody> loader) {
        Log.e((String)TAG, (String)loader.toString());
    }

    @Override
    public void reset() {
        List<Integer> ids;
        if (this.idsForNamedPipes == null) {
            this.idsForNamedPipes = new HashMap<String, List<Integer>>();
        }
        if ((ids = this.idsForNamedPipes.get(this.name)) != null) {
            for (Integer id : ids) {
                Loader loader;
                if (id == null || (loader = this.manager.getLoader(id.intValue())) == null) continue;
                this.manager.destroyLoader(id.intValue());
            }
        }
        this.idsForNamedPipes.put(this.name, new ArrayList());
    }

    @Override
    public void setLoaderIds(Map<String, List<Integer>> idsForNamedPipes) {
        this.idsForNamedPipes = idsForNamedPipes;
    }

    private void fragmentSuccess(Callback typelessCallback, Object data) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onSuccess(data);
        callback.setFragment(null);
    }

    private void fragmentFailure(Callback typelessCallback, Exception exception) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onFailure(exception);
        callback.setFragment(null);
    }

    private void activitySuccess(Callback typelessCallback, Object data) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onSuccess(data);
        callback.setActivity(null);
    }

    private void activityFailure(Callback typelessCallback, Exception exception) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onFailure(exception);
        callback.setActivity(null);
    }

    private Object extractObject(HeaderAndBody data, AbstractPipeLoader<HeaderAndBody> modernLoader) {
        List<T> results = this.responseParser.handleResponse(data, this.getKlass());
        if (results == null || results.size() == 0) {
            return results;
        }
        if (modernLoader instanceof SaveLoader || modernLoader instanceof IdReadLoader) {
            return results.get(0);
        }
        return results;
    }

    private void verifyCallback(Callback<List<T>> callback) {
        if (callback instanceof AbstractActivityCallback) {
            if (this.activity == null) {
                throw new IllegalStateException("An AbstractActivityCallback was supplied, but there is no Activity.");
            }
        } else if (callback instanceof AbstractFragmentCallback && this.fragment == null) {
            throw new IllegalStateException("An AbstractFragmentCallback was supplied, but there is no Fragment.");
        }
    }

    private synchronized void addId(String name, int id) {
        List<Integer> ids = this.idsForNamedPipes.get(name);
        if (ids == null) {
            ids = new ArrayList<Integer>();
            this.idsForNamedPipes.put(name, ids);
        }
        ids.add(id);
    }

    public static class CallbackHandler<T>
    implements Runnable {
        private final LoaderAdapter<T> adapter;
        private final AbstractPipeLoader<T> modernLoader;
        private final Object data;

        public CallbackHandler(LoaderAdapter<T> adapter, AbstractPipeLoader loader, Object data) {
            this.adapter = adapter;
            this.modernLoader = loader;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.modernLoader.hasException()) {
                Exception exception = this.modernLoader.getException();
                Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                    ((LoaderAdapter)this.adapter).fragmentFailure(this.modernLoader.getCallback(), exception);
                } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                    ((LoaderAdapter)this.adapter).activityFailure(this.modernLoader.getCallback(), exception);
                } else {
                    this.modernLoader.getCallback().onFailure(exception);
                }
            } else if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                ((LoaderAdapter)this.adapter).fragmentSuccess(this.modernLoader.getCallback(), this.data);
            } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                ((LoaderAdapter)this.adapter).activitySuccess(this.modernLoader.getCallback(), this.data);
            } else {
                this.modernLoader.getCallback().onSuccess(this.data);
            }
        }
    }

    private static enum Methods {
        READ,
        READ_ID,
        SAVE,
        REMOVE;

    }
}

