/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.paging;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.ReadFilter;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.paging.PagedList;

public class WrappingPagedList<T>
extends ArrayList<T>
implements PagedList<T> {
    private final Pipe<T> pipe;
    private final List<T> data;
    private final ReadFilter nextFilter;
    private final ReadFilter previousFilter;

    public WrappingPagedList(Pipe<T> pipe, List<T> data, ReadFilter nextFilter, ReadFilter previousFilter) {
        super(data);
        this.pipe = pipe;
        this.data = data;
        this.nextFilter = nextFilter;
        this.previousFilter = previousFilter;
    }

    @Override
    public void next(Callback<List<T>> callback) {
        this.pipe.read(this.nextFilter, callback);
    }

    @Override
    public void previous(Callback<List<T>> callback) {
        this.pipe.read(this.previousFilter, callback);
    }

    public ReadFilter getNextFilter() {
        return this.nextFilter;
    }

    public ReadFilter getPreviousFilter() {
        return this.previousFilter;
    }
}

