/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.paging;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aerogear.android.pipe.util.ParseException;

public class WebLink {
    private static final Pattern P = Pattern.compile("\\s*<(.*)>\\s*(.*)");
    private static final String EQUALS = "=";
    private String uri;
    private Map<String, String> parameters;

    public WebLink(String headerContent) throws ParseException {
        Matcher uriAndFields = P.matcher(headerContent);
        if (!uriAndFields.matches()) {
            throw new ParseException("Can not parse value:" + headerContent);
        }
        this.uri = uriAndFields.group(1);
        this.parameters = this.parseParams(uriAndFields.group(2));
    }

    private Map<String, String> parseParams(String group) throws ParseException {
        String[] params = group.split(";");
        HashMap<String, String> paramsMap = new HashMap<String, String>(params.length);
        for (String param : params) {
            if (param.trim().isEmpty()) continue;
            String[] pair = param.split(EQUALS);
            if (pair.length != 2) {
                throw new ParseException(param + " could not be parsed");
            }
            if (paramsMap.get(pair[0]) != null) continue;
            paramsMap.put(pair[0], pair[1].replace("\"", ""));
        }
        return paramsMap;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

