/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.gcm;

import android.content.Context;
import android.support.test.runner.AndroidJUnit4;
import java.net.URI;
import java.util.ArrayList;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushJsonConfiguration;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AndroidJUnit4.class)
public class AeroGearGCMPushJsonConfigurationTest
extends PatchedActivityInstrumentationTestCase {
    private static final URI pushServerURL = URI.create("https://localhost:8080/ag-push");
    private static final String senderId = "123456";
    private static final String variantID = "8abfae4eb02a6140c0a20798433180a063fd7006";
    private static final String secret = "5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8";

    public AeroGearGCMPushJsonConfigurationTest() {
        super(MainActivity.class);
    }

    @Test
    public void testJsonConfigUsingDefaultFileName() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.loadConfigJson((Context)this.getActivity());
        Assert.assertEquals((Object)pushServerURL, (Object)config.getPushServerURI());
        Assert.assertEquals((Object)senderId, (Object)config.getSenderId());
        Assert.assertEquals((Object)variantID, (Object)config.getVariantID());
        Assert.assertEquals((Object)secret, (Object)config.getSecret());
    }

    @Test
    public void testJsonConfigUsingDifferentFileName() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("correct-config.json");
        config.loadConfigJson((Context)this.getActivity());
        Assert.assertEquals((Object)pushServerURL, (Object)config.getPushServerURI());
        Assert.assertEquals((Object)senderId, (Object)config.getSenderId());
        Assert.assertEquals((Object)variantID, (Object)config.getVariantID());
        Assert.assertEquals((Object)secret, (Object)config.getSecret());
    }

    @Test
    public void testJsonConfigUsingIncorrectFileFormat() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("wrong-format.json");
        try {
            config.loadConfigJson((Context)this.getActivity());
            Assert.fail((String)"Somethings is wrong. File with incorrect format should throw an exception");
        }
        catch (RuntimeException e) {
            String errorMessage = "An error occurred while parsing the wrong-format.json. Please check the file format";
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
        Assert.assertNull((Object)config.getPushServerURI());
        Assert.assertNull((Object)config.getSenderId());
        Assert.assertNull((Object)config.getVariantID());
        Assert.assertNull((Object)config.getSecret());
    }

    @Test
    public void testJsonConfigUsingEmptyFile() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("empty-file.json");
        try {
            config.loadConfigJson((Context)this.getActivity());
            Assert.fail((String)"Somethings is wrong. Empty file should throw an exception");
        }
        catch (RuntimeException e) {
            String errorMessage = "An error occurred while parsing the empty-file.json. Please check the file format";
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testJsonConfigUsingAbsentFile() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setFileName("blablabla.json");
        try {
            config.loadConfigJson((Context)this.getActivity());
            Assert.fail((String)"Somethings is wrong. This file not exists and load should throw an exception");
        }
        catch (RuntimeException e) {
            String errorMessage = "An error occurred while parsing the blablabla.json. Please check if the file exists";
            Assert.assertEquals((Object)errorMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testSetCategoriesUsingStringArray() {
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setCategories(new String[]{"A", "B"});
        Assert.assertEquals((long)2L, (long)config.getCategories().size());
    }

    @Test
    public void testSetCategoriesUsingList() {
        ArrayList<String> myCategories = new ArrayList<String>();
        myCategories.add("A");
        myCategories.add("B");
        AeroGearGCMPushJsonConfiguration config = new AeroGearGCMPushJsonConfiguration();
        config.setCategories(myCategories);
        Assert.assertEquals((long)2L, (long)config.getCategories().size());
    }
}

