/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.http;

import android.util.Base64;
import java.net.URL;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.http.HttpRestProvider;

public class HttpRestProviderForPush
implements HttpProvider {
    private static final String BASIC_HEADER = "Authorization";
    private static final String AUTHORIZATION_METHOD = "Basic";
    private final HttpRestProvider provider;

    public HttpRestProviderForPush(URL url, Integer timeout) {
        this.provider = new HttpRestProvider(url, timeout);
    }

    @Override
    public URL getUrl() {
        return this.provider.getUrl();
    }

    @Override
    public HeaderAndBody get() throws HttpException {
        return this.provider.get();
    }

    @Override
    public HeaderAndBody post(String data) throws HttpException {
        return this.provider.post(data);
    }

    @Override
    public HeaderAndBody post(byte[] data) throws HttpException {
        return this.provider.post(data);
    }

    @Override
    public HeaderAndBody put(String id, String data) throws HttpException {
        return this.provider.put(id, data);
    }

    @Override
    public HeaderAndBody put(String id, byte[] data) throws HttpException {
        return this.provider.put(id, data);
    }

    @Override
    public HeaderAndBody delete(String id) throws HttpException {
        return this.provider.delete(id);
    }

    @Override
    public void setDefaultHeader(String headerName, String headerValue) {
        this.provider.setDefaultHeader(headerName, headerValue);
    }

    public void setPasswordAuthentication(String username, String password) {
        this.setDefaultHeader(BASIC_HEADER, this.getHashedAuth(username, password.toCharArray()));
    }

    private String getHashedAuth(String username, char[] password) {
        StringBuilder headerValueBuilder = new StringBuilder(AUTHORIZATION_METHOD).append(" ");
        String unhashedCredentials = username + ":" + password;
        String hashedCrentials = Base64.encodeToString((byte[])unhashedCredentials.getBytes(), (int)2);
        return headerValueBuilder.append(hashedCrentials).toString();
    }

    private static class EmptyCallback
    implements Callback<HeaderAndBody> {
        private static final long serialVersionUID = 1L;

        private EmptyCallback() {
        }

        @Override
        public void onSuccess(HeaderAndBody data) {
        }

        @Override
        public void onFailure(Exception e) {
        }
    }
}

