/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.impl.unifiedpush.DefaultPushRegistrarFactory;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.PushConfig;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.PushRegistrarFactory;

public class Registrations {
    private final PushRegistrarFactory factory;
    private final Map<String, PushRegistrar> registrars = new HashMap<String, PushRegistrar>();
    private static List<MessageHandler> mainThreadHandlers = new ArrayList<MessageHandler>();
    private static List<MessageHandler> backgroundThreadHandlers = new ArrayList<MessageHandler>();

    public Registrations() {
        this.factory = new DefaultPushRegistrarFactory();
    }

    public Registrations(PushRegistrarFactory factory) {
        this.factory = factory;
    }

    public PushRegistrar push(String name, PushConfig config) {
        PushRegistrar registrar = this.factory.createPushRegistrar(config);
        this.registrars.put(name, registrar);
        return registrar;
    }

    public PushRegistrar get(String name) {
        return this.registrars.get(name);
    }

    public static void registerMainThreadHandler(MessageHandler handler) {
        mainThreadHandlers.add(handler);
    }

    public static void registerBackgroundThreadHandler(MessageHandler handler) {
        backgroundThreadHandlers.add(handler);
    }

    public static void unregisterMainThreadHandler(MessageHandler handler) {
        mainThreadHandlers.remove(handler);
    }

    public static void unregisterBackgroundThreadHandler(MessageHandler handler) {
        backgroundThreadHandlers.remove(handler);
    }

    public static void notifyHandlers(final Context context, final Intent message, final MessageHandler defaultHandler) {
        if (backgroundThreadHandlers.isEmpty() && mainThreadHandlers.isEmpty() && defaultHandler != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.ERROR", false)) {
                        defaultHandler.onError();
                    } else if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.DELETED", false)) {
                        defaultHandler.onDeleteMessage(context, message.getExtras());
                    } else {
                        defaultHandler.onMessage(context, message.getExtras());
                    }
                }
            }).start();
        }
        for (final MessageHandler handler : backgroundThreadHandlers) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.ERROR", false)) {
                        handler.onError();
                    } else if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.DELETED", false)) {
                        handler.onDeleteMessage(context, message.getExtras());
                    } else {
                        handler.onMessage(context, message.getExtras());
                    }
                }
            }).start();
        }
        Looper main = Looper.getMainLooper();
        for (final MessageHandler handler : mainThreadHandlers) {
            new Handler(main).post(new Runnable(){

                @Override
                public void run() {
                    if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.ERROR", false)) {
                        handler.onError();
                    } else if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.DELETED", false)) {
                        handler.onDeleteMessage(context, message.getExtras());
                    } else {
                        handler.onMessage(context, message.getExtras());
                    }
                }
            });
        }
    }

    protected static void notifyHandlers(Context context, Intent message) {
        Registrations.notifyHandlers(context, message, null);
    }
}

