/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.aerogear.android.core.Config;
import org.jboss.aerogear.android.unifiedpush.OnPushRegistrarCreatedListener;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;

public abstract class PushConfiguration<CONFIGURATION extends PushConfiguration>
implements Config<CONFIGURATION> {
    private String name;
    private Collection<OnPushRegistrarCreatedListener> listeners = new HashSet<OnPushRegistrarCreatedListener>();

    public String getName() {
        return this.name;
    }

    public CONFIGURATION setName(String name) {
        this.name = name;
        return (CONFIGURATION)this;
    }

    public Collection<OnPushRegistrarCreatedListener> getOnAuthenticationCreatedListeners() {
        return this.listeners;
    }

    public CONFIGURATION addOnPushRegistrarCreatedListener(OnPushRegistrarCreatedListener listener) {
        this.listeners.add(listener);
        return (CONFIGURATION)this;
    }

    public CONFIGURATION setOnPushRegistrarCreatedListeners(Collection<OnPushRegistrarCreatedListener> listeners) {
        listeners.addAll(listeners);
        return (CONFIGURATION)this;
    }

    public final PushRegistrar asRegistrar() {
        PushRegistrar registrar = this.buildRegistrar();
        for (OnPushRegistrarCreatedListener listener : this.getOnAuthenticationCreatedListeners()) {
            listener.onPushRegistrarCreated(this, registrar);
        }
        return registrar;
    }

    protected abstract PushRegistrar buildRegistrar();
}

