/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.OnPushRegistrarCreatedListener;
import org.jboss.aerogear.android.unifiedpush.PushConfiguration;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfigurationProvider;

public class RegistrarManager {
    private static final Map<String, PushRegistrar> registrars = new HashMap<String, PushRegistrar>();
    private static final List<MessageHandler> mainThreadHandlers = new ArrayList<MessageHandler>();
    private static final List<MessageHandler> backgroundThreadHandlers = new ArrayList<MessageHandler>();
    private static Map<Class<? extends PushConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnPushRegistrarCreatedListener onPushRegistrarCreatedListener = new OnPushRegistrarCreatedListener(){

        @Override
        public void onPushRegistrarCreated(PushConfiguration<?> configuration, PushRegistrar registrar) {
            registrars.put(configuration.getName(), registrar);
        }
    };

    public static <CFG extends PushConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends PushConfiguration<CFG>> CFG config(String name, Class<CFG> pushConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(pushConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((PushConfiguration)provider.newConfiguration()).setName(name).addOnPushRegistrarCreatedListener(onPushRegistrarCreatedListener);
    }

    public static PushRegistrar getRegistrar(String name) {
        return registrars.get(name);
    }

    public static void registerMainThreadHandler(MessageHandler handler) {
        mainThreadHandlers.add(handler);
    }

    public static void registerBackgroundThreadHandler(MessageHandler handler) {
        backgroundThreadHandlers.add(handler);
    }

    public static void unregisterMainThreadHandler(MessageHandler handler) {
        mainThreadHandlers.remove(handler);
    }

    public static void unregisterBackgroundThreadHandler(MessageHandler handler) {
        backgroundThreadHandlers.remove(handler);
    }

    public static void notifyHandlers(final Context context, final Intent message, final MessageHandler defaultHandler) {
        if (backgroundThreadHandlers.isEmpty() && mainThreadHandlers.isEmpty() && defaultHandler != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.ERROR", false)) {
                        defaultHandler.onError();
                    } else if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.DELETED", false)) {
                        defaultHandler.onDeleteMessage(context, message.getExtras());
                    } else {
                        defaultHandler.onMessage(context, message.getExtras());
                    }
                }
            }).start();
        }
        for (final MessageHandler handler : backgroundThreadHandlers) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.ERROR", false)) {
                        handler.onError();
                    } else if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.DELETED", false)) {
                        handler.onDeleteMessage(context, message.getExtras());
                    } else {
                        handler.onMessage(context, message.getExtras());
                    }
                }
            }).start();
        }
        Looper main = Looper.getMainLooper();
        for (final MessageHandler handler : mainThreadHandlers) {
            new Handler(main).post(new Runnable(){

                @Override
                public void run() {
                    if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.ERROR", false)) {
                        handler.onError();
                    } else if (message.getBooleanExtra("org.jboss.aerogear.android.unifiedpush.DELETED", false)) {
                        handler.onDeleteMessage(context, message.getExtras());
                    } else {
                        handler.onMessage(context, message.getExtras());
                    }
                }
            });
        }
    }

    protected static void notifyHandlers(Context context, Intent message) {
        RegistrarManager.notifyHandlers(context, message, null);
    }

    static {
        AeroGearGCMPushConfigurationProvider basicConfigurationProvider = new AeroGearGCMPushConfigurationProvider();
        RegistrarManager.registerConfigurationProvider(AeroGearGCMPushConfiguration.class, basicConfigurationProvider);
    }
}

