/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.gcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.pipe.http.HttpRestProvider;
import org.jboss.aerogear.android.pipe.util.UrlUtils;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;

public class AeroGearGCMPushRegistrar
implements PushRegistrar {
    private static final String BASIC_HEADER = "Authorization";
    private static final String AUTHORIZATION_METHOD = "Basic";
    private static final Integer TIMEOUT = 30000;
    public static final long REGISTRATION_EXPIRY_TIME_MS = 604800000L;
    private static final String TAG = AeroGearGCMPushRegistrar.class.getSimpleName();
    public static final String PROPERTY_REG_ID = "registration_id";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static final String PROPERTY_ON_SERVER_EXPIRATION_TIME = "onServerExpirationTimeMs";
    private static final String registryDeviceEndpoint = "/rest/registry/device";
    private static final String DEVICE_ALREADY_UNREGISTERED = "Seems this device was already unregistered";
    private final Set<String> senderIds;
    private GoogleCloudMessaging gcm;
    private URL deviceRegistryURL;
    private String deviceToken = "";
    private final String secret;
    private final String variantId;
    private final String deviceType;
    private final String alias;
    private final String operatingSystem;
    private final String osVersion;
    private final List<String> categories;
    private Provider<HttpProvider> httpProviderProvider = new Provider<HttpProvider>(){

        public HttpProvider get(Object ... in) {
            return new HttpRestProvider((URL)in[0], (Integer)in[1]);
        }
    };
    private Provider<GoogleCloudMessaging> gcmProvider = new Provider<GoogleCloudMessaging>(){

        public GoogleCloudMessaging get(Object ... context) {
            return GoogleCloudMessaging.getInstance((Context)((Context)context[0]));
        }
    };

    public AeroGearGCMPushRegistrar(AeroGearGCMPushConfiguration config) {
        this.senderIds = config.getSenderIds();
        this.deviceToken = config.getDeviceToken();
        this.variantId = config.getVariantID();
        this.secret = config.getSecret();
        this.deviceType = config.getDeviceType();
        this.alias = config.getAlias();
        this.operatingSystem = config.getOperatingSystem();
        this.osVersion = config.getOsVersion();
        this.categories = new ArrayList<String>(config.getCategories());
        try {
            this.deviceRegistryURL = UrlUtils.appendToBaseURL((URL)config.getPushServerURI().toURL(), (String)registryDeviceEndpoint);
        }
        catch (MalformedURLException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
            throw new IllegalStateException("pushserverUrl was not a valid URL");
        }
    }

    @Override
    public void register(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    String regid;
                    if (AeroGearGCMPushRegistrar.this.gcm == null) {
                        AeroGearGCMPushRegistrar.this.gcm = (GoogleCloudMessaging)AeroGearGCMPushRegistrar.this.gcmProvider.get(new Object[]{context});
                    }
                    if ((regid = AeroGearGCMPushRegistrar.this.getRegistrationId(context)).length() == 0) {
                        regid = AeroGearGCMPushRegistrar.this.gcm.register(AeroGearGCMPushRegistrar.this.senderIds.toArray(new String[0]));
                        AeroGearGCMPushRegistrar.this.setRegistrationId(context, regid);
                    }
                    AeroGearGCMPushRegistrar.this.deviceToken = regid;
                    HttpProvider httpProvider = (HttpProvider)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearGCMPushRegistrar.this.deviceRegistryURL, TIMEOUT});
                    AeroGearGCMPushRegistrar.this.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.variantId, AeroGearGCMPushRegistrar.this.secret, httpProvider);
                    try {
                        JsonObject postData = new JsonObject();
                        postData.addProperty("deviceType", AeroGearGCMPushRegistrar.this.deviceType);
                        postData.addProperty("deviceToken", AeroGearGCMPushRegistrar.this.deviceToken);
                        postData.addProperty("alias", AeroGearGCMPushRegistrar.this.alias);
                        postData.addProperty("operatingSystem", AeroGearGCMPushRegistrar.this.operatingSystem);
                        postData.addProperty("osVersion", AeroGearGCMPushRegistrar.this.osVersion);
                        if (AeroGearGCMPushRegistrar.this.categories != null && !AeroGearGCMPushRegistrar.this.categories.isEmpty()) {
                            JsonArray jsonCategories = new JsonArray();
                            for (String category : AeroGearGCMPushRegistrar.this.categories) {
                                jsonCategories.add((JsonElement)new JsonPrimitive(category));
                            }
                            postData.add("categories", (JsonElement)jsonCategories);
                        }
                        httpProvider.post(postData.toString());
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else if (result instanceof HttpException) {
                    HttpException httpException = (HttpException)((Object)result);
                    switch (httpException.getStatusCode()) {
                        case 301: 
                        case 302: 
                        case 307: {
                            Log.w((String)TAG, (String)httpException.getMessage());
                            try {
                                URL redirectURL = new URL((String)httpException.getHeaders().get("Location"));
                                AeroGearGCMPushRegistrar.this.deviceRegistryURL = redirectURL;
                                AeroGearGCMPushRegistrar.this.register(context, (Callback<Void>)callback);
                            }
                            catch (MalformedURLException e) {
                                callback.onFailure((Exception)e);
                            }
                            break;
                        }
                        default: {
                            callback.onFailure(result);
                            break;
                        }
                    }
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    @Override
    public void unregister(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    if (AeroGearGCMPushRegistrar.this.deviceToken == null || AeroGearGCMPushRegistrar.this.deviceToken.trim().equals("")) {
                        throw new IllegalStateException(AeroGearGCMPushRegistrar.DEVICE_ALREADY_UNREGISTERED);
                    }
                    if (AeroGearGCMPushRegistrar.this.gcm == null) {
                        AeroGearGCMPushRegistrar.this.gcm = (GoogleCloudMessaging)AeroGearGCMPushRegistrar.this.gcmProvider.get(new Object[]{context});
                    }
                    AeroGearGCMPushRegistrar.this.gcm.unregister();
                    HttpProvider provider = (HttpProvider)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearGCMPushRegistrar.this.deviceRegistryURL, TIMEOUT});
                    AeroGearGCMPushRegistrar.this.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.variantId, AeroGearGCMPushRegistrar.this.secret, provider);
                    try {
                        provider.delete(AeroGearGCMPushRegistrar.this.deviceToken);
                        AeroGearGCMPushRegistrar.this.deviceToken = "";
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    public String getRegistrationId(Context context) {
        int currentVersion;
        SharedPreferences prefs = this.getGCMPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        if (registrationId.length() == 0) {
            Log.v((String)TAG, (String)"Registration not found.");
            return "";
        }
        int registeredVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = AeroGearGCMPushRegistrar.getAppVersion(context)) || this.isRegistrationExpired(context)) {
            Log.v((String)TAG, (String)"App version changed or registration expired.");
            return "";
        }
        return registrationId;
    }

    private SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(AeroGearGCMPushRegistrar.class.getSimpleName(), 0);
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e));
        }
    }

    private boolean isRegistrationExpired(Context context) {
        SharedPreferences prefs = this.getGCMPreferences(context);
        long expirationTime = prefs.getLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, -1L);
        return System.currentTimeMillis() > expirationTime;
    }

    private void setRegistrationId(Context context, String regId) {
        SharedPreferences prefs = this.getGCMPreferences(context);
        int appVersion = AeroGearGCMPushRegistrar.getAppVersion(context);
        Log.v((String)TAG, (String)("Saving regId on app version " + appVersion));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REG_ID, regId);
        editor.putInt(PROPERTY_APP_VERSION, appVersion);
        long expirationTime = System.currentTimeMillis() + 604800000L;
        Log.v((String)TAG, (String)("Setting registration expiry time to " + new Timestamp(expirationTime)));
        editor.putLong(PROPERTY_ON_SERVER_EXPIRATION_TIME, expirationTime);
        editor.commit();
    }

    public void setPasswordAuthentication(String username, String password, HttpProvider provider) {
        provider.setDefaultHeader(BASIC_HEADER, this.getHashedAuth(username, password.toCharArray()));
    }

    private String getHashedAuth(String username, char[] password) {
        StringBuilder headerValueBuilder = new StringBuilder(AUTHORIZATION_METHOD).append(" ");
        String unhashedCredentials = username + ":" + password;
        String hashedCrentials = Base64.encodeToString((byte[])unhashedCredentials.getBytes(), (int)2);
        return headerValueBuilder.append(hashedCrentials).toString();
    }
}

