/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.gcm;

import android.os.Build;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.aerogear.android.unifiedpush.PushConfiguration;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar;

public class AeroGearGCMPushConfiguration
extends PushConfiguration<AeroGearGCMPushConfiguration> {
    private static final long serialVersionUID = 1L;
    private String deviceToken = "";
    private String variantID;
    private String secret;
    private String deviceType = "ANDROID";
    private String operatingSystem = "android";
    private String osVersion = Build.VERSION.RELEASE;
    private String alias;
    private List<String> categories = new ArrayList<String>();
    private URI pushServerURI;
    private Set<String> senderIds = new HashSet<String>();

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public AeroGearGCMPushConfiguration setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        return this;
    }

    public String getVariantID() {
        return this.variantID;
    }

    public AeroGearGCMPushConfiguration setVariantID(String variantID) {
        this.variantID = variantID;
        return this;
    }

    public String getSecret() {
        return this.secret;
    }

    public AeroGearGCMPushConfiguration setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public AeroGearGCMPushConfiguration setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public AeroGearGCMPushConfiguration setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public AeroGearGCMPushConfiguration setOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public String getAlias() {
        return this.alias;
    }

    public AeroGearGCMPushConfiguration setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public AeroGearGCMPushConfiguration setCategories(List<String> categories) {
        this.categories = new ArrayList<String>(categories);
        return this;
    }

    public AeroGearGCMPushConfiguration setCategories(String ... categories) {
        this.categories = Arrays.asList(categories);
        return this;
    }

    public AeroGearGCMPushConfiguration addCategory(String category) {
        this.categories.add(category);
        return this;
    }

    public URI getPushServerURI() {
        return this.pushServerURI;
    }

    public AeroGearGCMPushConfiguration setPushServerURI(URI pushServerURI) {
        this.pushServerURI = pushServerURI;
        return this;
    }

    public Set<String> getSenderIds() {
        return new HashSet<String>(this.senderIds);
    }

    public AeroGearGCMPushConfiguration setSenderIds(String ... senderIds) {
        HashSet<String> newSenderIds = new HashSet<String>(senderIds.length);
        Collections.addAll(newSenderIds, senderIds);
        this.senderIds = newSenderIds;
        return this;
    }

    public AeroGearGCMPushConfiguration addSenderId(String senderId) {
        this.senderIds.add(senderId);
        return this;
    }

    @Override
    protected final AeroGearGCMPushRegistrar buildRegistrar() {
        this.checkRequiredFields();
        return new AeroGearGCMPushRegistrar(this);
    }

    private void checkRequiredFields() {
        if (this.senderIds == null || this.senderIds.isEmpty()) {
            throw new IllegalStateException("SenderIds can't be null or empty");
        }
        if (this.pushServerURI == null) {
            throw new IllegalStateException("PushServerURI can't be null");
        }
        if (this.variantID == null) {
            throw new IllegalStateException("VariantID can't be null");
        }
        if (this.secret == null) {
            throw new IllegalStateException("Secret can't be null");
        }
    }
}

