/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.gcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.gcm.GcmListenerService;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.RegistrarManager;

public class AeroGearGCMMessageReceiver
extends GcmListenerService {
    public static final int NOTIFICATION_ID = 1;
    private static MessageHandler defaultHandler;
    private static boolean checkDefaultHandler;
    private static final String TAG;
    public static final String DEFAULT_MESSAGE_HANDLER_KEY = "DEFAULT_MESSAGE_HANDLER_KEY";

    public void onMessageReceived(String from, Bundle message) {
        super.onMessageReceived(from, message);
        if (checkDefaultHandler) {
            String defaultHandlerClassName;
            checkDefaultHandler = false;
            Bundle metaData = this.getMetadata(this.getApplicationContext());
            if (metaData != null && (defaultHandlerClassName = metaData.getString(DEFAULT_MESSAGE_HANDLER_KEY)) != null) {
                try {
                    Class<?> defaultHandlerClass = Class.forName(defaultHandlerClassName);
                    defaultHandler = (MessageHandler)defaultHandlerClass.newInstance();
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        RegistrarManager.notifyHandlers(this.getApplicationContext(), message, defaultHandler);
    }

    private Bundle getMetadata(Context context) {
        ComponentName componentName = new ComponentName(context, AeroGearGCMMessageReceiver.class);
        try {
            ServiceInfo si = context.getPackageManager().getServiceInfo(componentName, 128);
            Bundle metaData = si.metaData;
            if (metaData != null) {
                return metaData;
            }
            Log.d((String)TAG, (String)("metaData is null. Unable to get meta data for " + componentName));
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    static {
        checkDefaultHandler = true;
        TAG = AeroGearGCMMessageReceiver.class.getSimpleName();
    }
}

