/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.gcm;

import android.content.Context;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.jboss.aerogear.android.unifiedpush.PushConfiguration;
import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar;
import org.jboss.aerogear.android.unifiedpush.gcm.UnifiedPushConfig;
import org.json.JSONException;
import org.json.JSONObject;

public class AeroGearGCMPushJsonConfiguration
extends PushConfiguration<AeroGearGCMPushJsonConfiguration> {
    private static final String TAG = AeroGearGCMPushJsonConfiguration.class.getName();
    private static final String JSON_OBJECT = "android";
    private static final String JSON_URL = "pushServerURL";
    private static final String JSON_SENDER_ID = "senderID";
    private static final String JSON_VARIANT_ID = "variantID";
    private static final String JSON_VARIANT_SECRET = "variantSecret";
    private final UnifiedPushConfig pushConfig = new UnifiedPushConfig();
    private String fileName = "push-config.json";

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public URI getPushServerURI() {
        return this.pushConfig.getPushServerURI();
    }

    public String getSenderId() {
        return this.pushConfig.getSenderId();
    }

    public AeroGearGCMPushJsonConfiguration setSenderId(String senderId) {
        this.pushConfig.setSenderId(senderId);
        return this;
    }

    public String getVariantID() {
        return this.pushConfig.getVariantID();
    }

    public String getSecret() {
        return this.pushConfig.getSecret();
    }

    public String getDeviceToken() {
        return this.pushConfig.getDeviceToken();
    }

    public String getDeviceType() {
        return this.pushConfig.getDeviceType();
    }

    public AeroGearGCMPushJsonConfiguration setDeviceType(String deviceType) {
        this.pushConfig.setDeviceType(deviceType);
        return this;
    }

    public String getOperatingSystem() {
        return this.pushConfig.getOperatingSystem();
    }

    public AeroGearGCMPushJsonConfiguration setOperatingSystem(String operatingSystem) {
        this.pushConfig.setOperatingSystem(operatingSystem);
        return this;
    }

    public String getOsVersion() {
        return this.pushConfig.getOsVersion();
    }

    public String getAlias() {
        return this.pushConfig.getAlias();
    }

    public AeroGearGCMPushJsonConfiguration setAlias(String alias) {
        this.pushConfig.setAlias(alias);
        return this;
    }

    public List<String> getCategories() {
        return this.pushConfig.getCategories();
    }

    public AeroGearGCMPushJsonConfiguration setCategories(List<String> categories) {
        this.pushConfig.setCategories(categories);
        return this;
    }

    public AeroGearGCMPushJsonConfiguration addCategories(List<String> categories) {
        this.pushConfig.addCategories(categories);
        return this;
    }

    public AeroGearGCMPushJsonConfiguration setCategories(String ... categories) {
        this.pushConfig.setCategories(categories);
        return this;
    }

    public AeroGearGCMPushJsonConfiguration addCategory(String category) {
        this.pushConfig.addCategory(category);
        return this;
    }

    public AeroGearGCMPushJsonConfiguration loadConfigJson(Context context) {
        InputStream fileStream = null;
        try {
            fileStream = context.getResources().getAssets().open(this.getFileName());
            int size = fileStream.available();
            byte[] buffer = new byte[size];
            fileStream.read(buffer);
            fileStream.close();
            String json = new String(buffer);
            JSONObject pushConfig = new JSONObject(json);
            JSONObject pushAndroidConfig = pushConfig.getJSONObject(JSON_OBJECT);
            this.pushConfig.setPushServerURI(new URI(pushConfig.getString(JSON_URL)));
            this.pushConfig.setSenderId(pushAndroidConfig.getString(JSON_SENDER_ID));
            this.pushConfig.setVariantID(pushAndroidConfig.getString(JSON_VARIANT_ID));
            this.pushConfig.setSecret(pushAndroidConfig.getString(JSON_VARIANT_SECRET));
        }
        catch (URISyntaxException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException("An error occurred while parsing the " + this.getFileName() + ". Please check the file format");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            throw new RuntimeException("An error occurred while parsing the " + this.getFileName() + ". Please check if the file exists");
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {}
            }
        }
        return this;
    }

    @Override
    protected final AeroGearGCMPushRegistrar buildRegistrar() {
        this.pushConfig.checkRequiredFields();
        return new AeroGearGCMPushRegistrar(this.pushConfig);
    }
}

