/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.gcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.gcm.GcmPubSub;
import com.google.android.gms.iid.InstanceID;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.pipe.http.HttpRestProvider;
import org.jboss.aerogear.android.pipe.util.UrlUtils;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.gcm.GCMSharedPreferenceProvider;
import org.jboss.aerogear.android.unifiedpush.gcm.UnifiedPushConfig;
import org.jboss.aerogear.android.unifiedpush.metrics.MetricsSender;
import org.jboss.aerogear.android.unifiedpush.metrics.UnifiedPushMetricsMessage;

public class AeroGearGCMPushRegistrar
implements PushRegistrar,
MetricsSender<UnifiedPushMetricsMessage> {
    private static final String BASIC_HEADER = "Authorization";
    private static final String AUTHORIZATION_METHOD = "Basic";
    private static final String LEGACY_PROPERTY_REG_ID = "registration_id";
    private static final Integer TIMEOUT = 30000;
    private static final String TAG = AeroGearGCMPushRegistrar.class.getSimpleName();
    static final String REGISTRAR_PREFERENCE_PATTERN = "org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:.+";
    static final String REGISTRAR_PREFERENCE_TEMPLATE = "org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:%s";
    private static final String registryDeviceEndpoint = "/rest/registry/device";
    private static final String metricsEndpoint = "/rest/registry/device/pushMessage";
    private static final String DEVICE_ALREADY_UNREGISTERED = "Seems this device was already unregistered";
    private final String senderId;
    private InstanceID instanceId;
    private URL deviceRegistryURL;
    private URL metricsURL;
    private String deviceToken = "";
    private final String secret;
    private final String variantId;
    private final String deviceType;
    private final String alias;
    private final String operatingSystem;
    private final String osVersion;
    private final ArrayList<String> categories;
    private Provider<HttpProvider> httpProviderProvider = new Provider<HttpProvider>(){

        public HttpProvider get(Object ... in) {
            return new HttpRestProvider((URL)in[0], (Integer)in[1]);
        }
    };
    private Provider<InstanceID> instanceIdProvider = new Provider<InstanceID>(){

        public InstanceID get(Object ... context) {
            return InstanceID.getInstance((Context)((Context)context[0]));
        }
    };
    private Provider<GcmPubSub> gcmPubProvider = new Provider<GcmPubSub>(){

        public GcmPubSub get(Object ... context) {
            return GcmPubSub.getInstance((Context)((Context)context[0]));
        }
    };
    private Provider<SharedPreferences> preferenceProvider = new GCMSharedPreferenceProvider();

    public AeroGearGCMPushRegistrar(UnifiedPushConfig config) {
        this.senderId = config.getSenderId();
        this.deviceToken = config.getDeviceToken();
        this.variantId = config.getVariantID();
        this.secret = config.getSecret();
        this.deviceType = config.getDeviceType();
        this.alias = config.getAlias();
        this.operatingSystem = config.getOperatingSystem();
        this.osVersion = config.getOsVersion();
        this.categories = new ArrayList<String>(config.getCategories());
        try {
            this.deviceRegistryURL = UrlUtils.appendToBaseURL((URL)config.getPushServerURI().toURL(), (String)registryDeviceEndpoint);
            this.metricsURL = UrlUtils.appendToBaseURL((URL)config.getPushServerURI().toURL(), (String)metricsEndpoint);
        }
        catch (MalformedURLException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
            throw new IllegalStateException("pushserverUrl was not a valid URL");
        }
    }

    @Override
    public void register(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    AeroGearGCMPushRegistrar.this.removeLegacyRegistrationId(context);
                    if (AeroGearGCMPushRegistrar.this.instanceId == null) {
                        AeroGearGCMPushRegistrar.this.instanceId = (InstanceID)AeroGearGCMPushRegistrar.this.instanceIdProvider.get(new Object[]{context});
                    }
                    String token = AeroGearGCMPushRegistrar.this.instanceId.getToken(AeroGearGCMPushRegistrar.this.senderId, "GCM");
                    AeroGearGCMPushRegistrar.this.deviceToken = token;
                    HttpProvider httpProvider = (HttpProvider)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearGCMPushRegistrar.this.deviceRegistryURL, TIMEOUT});
                    AeroGearGCMPushRegistrar.this.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.variantId, AeroGearGCMPushRegistrar.this.secret, httpProvider);
                    try {
                        JsonObject postData = new JsonObject();
                        postData.addProperty("deviceType", AeroGearGCMPushRegistrar.this.deviceType);
                        postData.addProperty("deviceToken", AeroGearGCMPushRegistrar.this.deviceToken);
                        postData.addProperty("alias", AeroGearGCMPushRegistrar.this.alias);
                        postData.addProperty("operatingSystem", AeroGearGCMPushRegistrar.this.operatingSystem);
                        postData.addProperty("osVersion", AeroGearGCMPushRegistrar.this.osVersion);
                        if (AeroGearGCMPushRegistrar.this.categories != null && !AeroGearGCMPushRegistrar.this.categories.isEmpty()) {
                            JsonArray jsonCategories = new JsonArray();
                            for (String category : AeroGearGCMPushRegistrar.this.categories) {
                                jsonCategories.add((JsonElement)new JsonPrimitive(category));
                            }
                            postData.add("categories", (JsonElement)jsonCategories);
                        }
                        httpProvider.post(postData.toString());
                        postData.addProperty("deviceRegistryURL", AeroGearGCMPushRegistrar.this.deviceRegistryURL.toString());
                        postData.addProperty("variantId", AeroGearGCMPushRegistrar.this.variantId);
                        postData.addProperty("secret", AeroGearGCMPushRegistrar.this.secret);
                        AeroGearGCMPushRegistrar.this.presistPostInformation(context.getApplicationContext(), postData);
                        GcmPubSub gcmPubSub = (GcmPubSub)AeroGearGCMPushRegistrar.this.gcmPubProvider.get(new Object[]{context});
                        for (String catgory : AeroGearGCMPushRegistrar.this.categories) {
                            gcmPubSub.subscribe(AeroGearGCMPushRegistrar.this.deviceToken, "/topics/" + catgory, null);
                        }
                        gcmPubSub.subscribe(AeroGearGCMPushRegistrar.this.deviceToken, "/topics/" + AeroGearGCMPushRegistrar.this.variantId, null);
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else if (result instanceof HttpException) {
                    HttpException httpException = (HttpException)((Object)result);
                    switch (httpException.getStatusCode()) {
                        case 301: 
                        case 302: 
                        case 307: {
                            Log.w((String)TAG, (String)httpException.getMessage());
                            try {
                                URL redirectURL = new URL((String)httpException.getHeaders().get("Location"));
                                AeroGearGCMPushRegistrar.this.deviceRegistryURL = redirectURL;
                                AeroGearGCMPushRegistrar.this.register(context, (Callback<Void>)callback);
                            }
                            catch (MalformedURLException e) {
                                callback.onFailure((Exception)e);
                            }
                            break;
                        }
                        default: {
                            callback.onFailure(result);
                            break;
                        }
                    }
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    @Override
    public void unregister(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    if (AeroGearGCMPushRegistrar.this.deviceToken == null || AeroGearGCMPushRegistrar.this.deviceToken.trim().equals("")) {
                        throw new IllegalStateException(AeroGearGCMPushRegistrar.DEVICE_ALREADY_UNREGISTERED);
                    }
                    if (AeroGearGCMPushRegistrar.this.instanceId == null) {
                        AeroGearGCMPushRegistrar.this.instanceId = (InstanceID)AeroGearGCMPushRegistrar.this.instanceIdProvider.get(new Object[]{context});
                    }
                    GcmPubSub gcmPubSub = (GcmPubSub)AeroGearGCMPushRegistrar.this.gcmPubProvider.get(new Object[]{context});
                    for (String catgory : AeroGearGCMPushRegistrar.this.categories) {
                        gcmPubSub.unsubscribe(AeroGearGCMPushRegistrar.this.deviceToken, "/topics/" + catgory);
                    }
                    gcmPubSub.unsubscribe(AeroGearGCMPushRegistrar.this.deviceToken, "/topics/" + AeroGearGCMPushRegistrar.this.variantId);
                    AeroGearGCMPushRegistrar.this.instanceId.deleteToken(AeroGearGCMPushRegistrar.this.senderId, "GCM");
                    HttpProvider provider = (HttpProvider)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearGCMPushRegistrar.this.deviceRegistryURL, TIMEOUT});
                    AeroGearGCMPushRegistrar.this.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.variantId, AeroGearGCMPushRegistrar.this.secret, provider);
                    try {
                        provider.delete(AeroGearGCMPushRegistrar.this.deviceToken);
                        AeroGearGCMPushRegistrar.this.deviceToken = "";
                        AeroGearGCMPushRegistrar.this.removeSavedPostData(context.getApplicationContext());
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    @Override
    public void sendMetrics(final UnifiedPushMetricsMessage metricsMessage, final Callback<UnifiedPushMetricsMessage> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    if (metricsMessage.getMessageId() == null || metricsMessage.getMessageId().trim().equals("")) {
                        throw new IllegalStateException("Message ID cannot be null or blank");
                    }
                    HttpProvider provider = (HttpProvider)AeroGearGCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearGCMPushRegistrar.this.metricsURL, TIMEOUT});
                    AeroGearGCMPushRegistrar.this.setPasswordAuthentication(AeroGearGCMPushRegistrar.this.variantId, AeroGearGCMPushRegistrar.this.secret, provider);
                    try {
                        provider.put(metricsMessage.getMessageId(), "");
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess((Object)metricsMessage);
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    public void setPasswordAuthentication(String username, String password, HttpProvider provider) {
        provider.setDefaultHeader(BASIC_HEADER, this.getHashedAuth(username, password.toCharArray()));
    }

    private String getHashedAuth(String username, char[] password) {
        StringBuilder headerValueBuilder = new StringBuilder(AUTHORIZATION_METHOD).append(" ");
        String unhashedCredentials = username + ":" + password;
        String hashedCrentials = Base64.encodeToString((byte[])unhashedCredentials.getBytes(), (int)2);
        return headerValueBuilder.append(hashedCrentials).toString();
    }

    private void presistPostInformation(Context appContext, JsonObject postData) {
        ((SharedPreferences)this.preferenceProvider.get(new Object[]{appContext})).edit().putString(String.format(REGISTRAR_PREFERENCE_TEMPLATE, this.senderId), postData.toString()).commit();
    }

    private void removeSavedPostData(Context appContext) {
        ((SharedPreferences)this.preferenceProvider.get(new Object[]{appContext})).edit().remove(String.format(REGISTRAR_PREFERENCE_TEMPLATE, this.senderId)).commit();
    }

    private void removeLegacyRegistrationId(Context context) {
        try {
            SharedPreferences prefs = context.getSharedPreferences(AeroGearGCMPushRegistrar.class.getSimpleName(), 0);
            String registrationId = prefs.getString(LEGACY_PROPERTY_REG_ID, "");
            if (registrationId.length() != 0) {
                Log.v((String)TAG, (String)("Found legacy ID: '" + registrationId + "'"));
                HttpProvider provider = (HttpProvider)this.httpProviderProvider.get(new Object[]{this.deviceRegistryURL, TIMEOUT});
                this.setPasswordAuthentication(this.variantId, this.secret, provider);
                provider.delete(registrationId);
                prefs.edit().remove(LEGACY_PROPERTY_REG_ID).commit();
            }
        }
        catch (Exception ignore) {
            Log.v((String)TAG, (String)"Exception Thrown attempting to unregister legacy token", (Throwable)ignore);
        }
    }
}

