/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.gcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.pipe.http.HttpRestProvider;
import org.jboss.aerogear.android.unifiedpush.gcm.GCMSharedPreferenceProvider;

public class UnifiedPushInstanceIDListenerService
extends InstanceIDListenerService {
    private static final String BASIC_HEADER = "Authorization";
    private static final String AUTHORIZATION_METHOD = "Basic";
    private static final String TAG = UnifiedPushInstanceIDListenerService.class.getSimpleName();
    private static final Integer TIMEOUT = 30000;
    private final Provider<SharedPreferences> sharedPreferencesProvider = new GCMSharedPreferenceProvider();
    private final Provider<InstanceID> instanceIdProvider = new Provider<InstanceID>(){

        public InstanceID get(Object ... context) {
            return InstanceID.getInstance((Context)((Context)context[0]));
        }
    };
    private final Provider<HttpProvider> httpProviderProvider = new Provider<HttpProvider>(){

        public HttpProvider get(Object ... in) {
            return new HttpRestProvider((URL)in[0], (Integer)in[1]);
        }
    };

    public void onTokenRefresh() {
        SharedPreferences sharedPreferences = (SharedPreferences)this.sharedPreferencesProvider.get(new Object[]{this});
        Map preferences = sharedPreferences.getAll();
        for (Map.Entry preference : preferences.entrySet()) {
            if (!((String)preference.getKey()).matches("org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:.+")) continue;
            String senderId = ((String)preference.getKey()).split(":")[1];
            InstanceID instanceID = (InstanceID)this.instanceIdProvider.get(new Object[]{this});
            try {
                String token = instanceID.getToken(senderId, "GCM");
                JsonObject oldPostData = new JsonParser().parse(preference.getValue().toString()).getAsJsonObject();
                URL deviceRegistryURL = new URL(oldPostData.get("deviceRegistryURL").getAsString());
                String variantId = oldPostData.get("variantId").getAsString();
                String secret = oldPostData.get("secret").getAsString();
                HttpProvider httpProvider = (HttpProvider)this.httpProviderProvider.get(new Object[]{deviceRegistryURL, TIMEOUT});
                this.setPasswordAuthentication(variantId, secret, httpProvider);
                JsonObject postData = new JsonObject();
                if (oldPostData.has("deviceType") && !oldPostData.get("deviceType").isJsonNull()) {
                    postData.addProperty("deviceType", oldPostData.get("deviceType").getAsString());
                }
                postData.addProperty("deviceToken", token);
                if (oldPostData.has("alias") && !oldPostData.get("alias").isJsonNull()) {
                    postData.addProperty("alias", oldPostData.get("alias").getAsString());
                }
                if (oldPostData.has("operatingSystem") && !oldPostData.get("operatingSystem").isJsonNull()) {
                    postData.addProperty("operatingSystem", oldPostData.get("operatingSystem").getAsString());
                }
                if (oldPostData.has("osVersion") && !oldPostData.get("osVersion").isJsonNull()) {
                    postData.addProperty("osVersion", oldPostData.get("osVersion").getAsString());
                }
                if (oldPostData.has("categories") && !oldPostData.get("categories").isJsonNull()) {
                    postData.add("categories", (JsonElement)oldPostData.get("categories").getAsJsonArray());
                }
                httpProvider.post(postData.toString());
            }
            catch (IOException ex) {
                Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void setPasswordAuthentication(String username, String password, HttpProvider provider) {
        provider.setDefaultHeader(BASIC_HEADER, this.getHashedAuth(username, password.toCharArray()));
    }

    private String getHashedAuth(String username, char[] password) {
        StringBuilder headerValueBuilder = new StringBuilder(AUTHORIZATION_METHOD).append(" ");
        String unhashedCredentials = username + ":" + password;
        String hashedCrentials = Base64.encodeToString((byte[])unhashedCredentials.getBytes(), (int)2);
        return headerValueBuilder.append(hashedCrentials).toString();
    }
}

