/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.fcm;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.RegistrarManager;

public class AeroGearFCMMessageReceiver
extends FirebaseMessagingService {
    public static final int NOTIFICATION_ID = 1;
    private static MessageHandler defaultHandler;
    private static boolean checkDefaultHandler;
    private static final String TAG;
    public static final String DEFAULT_MESSAGE_HANDLER_KEY = "DEFAULT_MESSAGE_HANDLER_KEY";

    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map messageMap = remoteMessage.getData();
        Bundle message = new Bundle();
        for (Map.Entry messageMapEntry : messageMap.entrySet()) {
            message.putString((String)messageMapEntry.getKey(), (String)messageMapEntry.getValue());
        }
        if (checkDefaultHandler) {
            String defaultHandlerClassName;
            checkDefaultHandler = false;
            Bundle metaData = this.getMetadata(this.getApplicationContext());
            if (metaData != null && (defaultHandlerClassName = metaData.getString(DEFAULT_MESSAGE_HANDLER_KEY)) != null) {
                try {
                    Class<?> defaultHandlerClass = Class.forName(defaultHandlerClassName);
                    defaultHandler = (MessageHandler)defaultHandlerClass.newInstance();
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        RegistrarManager.notifyHandlers(this.getApplicationContext(), message, defaultHandler);
    }

    private Bundle getMetadata(Context context) {
        try {
            ComponentName componentName = new ComponentName(context, AeroGearFCMMessageReceiver.class);
            ApplicationInfo si = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle metaData = si.metaData;
            if (metaData != null) {
                return metaData;
            }
            Log.d((String)TAG, (String)("metaData is null. Unable to get meta data for " + componentName));
        }
        catch (PackageManager.NameNotFoundException ex) {
            Logger.getLogger(AeroGearFCMMessageReceiver.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    static {
        checkDefaultHandler = true;
        TAG = AeroGearFCMMessageReceiver.class.getSimpleName();
    }
}

