/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.fcm;

import android.os.Build;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class UnifiedPushConfig {
    private URI pushServerURI;
    private String senderId;
    private String variantID;
    private String secret;
    private String deviceToken = "";
    private String deviceType = "ANDROID";
    private String operatingSystem = "android";
    private String osVersion = Build.VERSION.RELEASE;
    private String alias;
    private List<String> categories = new ArrayList<String>();
    private static final String FCM_TOPIC_PATTERN = "[a-zA-Z0-9-_.~%]{1,900}";

    public URI getPushServerURI() {
        return this.pushServerURI;
    }

    public UnifiedPushConfig setPushServerURI(URI pushServerURI) {
        this.pushServerURI = pushServerURI;
        return this;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public UnifiedPushConfig setSenderId(String senderId) {
        this.senderId = senderId;
        return this;
    }

    public String getVariantID() {
        return this.variantID;
    }

    public UnifiedPushConfig setVariantID(String variantID) {
        this.variantID = variantID;
        return this;
    }

    public String getSecret() {
        return this.secret;
    }

    public UnifiedPushConfig setSecret(String secret) {
        this.secret = secret;
        return this;
    }

    public String getDeviceToken() {
        return this.deviceToken;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public UnifiedPushConfig setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public UnifiedPushConfig setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAlias() {
        return this.alias;
    }

    public UnifiedPushConfig setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public List<String> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public UnifiedPushConfig setCategories(List<String> categories) {
        UnifiedPushConfig.validateCategories(categories.toArray(new String[categories.size()]));
        this.categories = new ArrayList<String>(categories);
        return this;
    }

    public UnifiedPushConfig setCategories(String ... categories) {
        UnifiedPushConfig.validateCategories(categories);
        this.categories = Arrays.asList(categories);
        return this;
    }

    public UnifiedPushConfig addCategory(String category) {
        UnifiedPushConfig.validateCategories(category);
        this.categories.add(category);
        return this;
    }

    public UnifiedPushConfig addCategories(List<String> categories) {
        UnifiedPushConfig.validateCategories(categories.toArray(new String[categories.size()]));
        this.categories.addAll(categories);
        return this;
    }

    public void checkRequiredFields() {
        if (this.senderId == null || this.senderId.isEmpty()) {
            throw new IllegalStateException("SenderId can't be null or empty");
        }
        if (this.pushServerURI == null) {
            throw new IllegalStateException("PushServerURI can't be null");
        }
        if (this.variantID == null) {
            throw new IllegalStateException("VariantID can't be null");
        }
        if (this.secret == null) {
            throw new IllegalStateException("Secret can't be null");
        }
    }

    private static void validateCategories(String ... categories) {
        for (String category : categories) {
            if (category.matches(FCM_TOPIC_PATTERN)) continue;
            throw new IllegalArgumentException(String.format("%s does not match %s", category, FCM_TOPIC_PATTERN));
        }
    }
}

