/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.OnPushRegistrarCreatedListener;
import org.jboss.aerogear.android.unifiedpush.PushConfiguration;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushConfigurationProvider;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushJsonConfiguration;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushJsonConfigurationProvider;

public class RegistrarManager {
    private static final Map<String, PushRegistrar> REGISTRARS = new HashMap<String, PushRegistrar>();
    private static final List<MessageHandler> MAIN_THREAD_HANDLERS = new ArrayList<MessageHandler>();
    private static final List<MessageHandler> BACKGROUND_THREAD_HANDLERS = new ArrayList<MessageHandler>();
    private static final Map<Class<? extends PushConfiguration<?>>, ConfigurationProvider<?>> CONFIGURATION_PROVIDER_MAP = new HashMap();
    private static final OnPushRegistrarCreatedListener ON_PUSH_REGISTRAR_CREATED_LISTENER = new OnPushRegistrarCreatedListener(){

        @Override
        public void onPushRegistrarCreated(PushConfiguration<?> configuration, PushRegistrar registrar) {
            REGISTRARS.put(configuration.getName(), registrar);
        }
    };

    public static <CFG extends PushConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        CONFIGURATION_PROVIDER_MAP.put(configurationClass, provider);
    }

    public static <CFG extends PushConfiguration<CFG>> CFG config(String name, Class<CFG> pushConfigurationClass) {
        ConfigurationProvider<?> provider = CONFIGURATION_PROVIDER_MAP.get(pushConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((PushConfiguration)provider.newConfiguration()).setName(name).addOnPushRegistrarCreatedListener(ON_PUSH_REGISTRAR_CREATED_LISTENER);
    }

    public static PushRegistrar getRegistrar(String name) {
        return REGISTRARS.get(name);
    }

    public static void registerMainThreadHandler(MessageHandler handler) {
        MAIN_THREAD_HANDLERS.add(handler);
    }

    public static void registerBackgroundThreadHandler(MessageHandler handler) {
        BACKGROUND_THREAD_HANDLERS.add(handler);
    }

    public static void unregisterMainThreadHandler(MessageHandler handler) {
        MAIN_THREAD_HANDLERS.remove(handler);
    }

    public static void unregisterBackgroundThreadHandler(MessageHandler handler) {
        BACKGROUND_THREAD_HANDLERS.remove(handler);
    }

    public static void notifyHandlers(final Context context, final Bundle message, final MessageHandler defaultHandler) {
        if (BACKGROUND_THREAD_HANDLERS.isEmpty() && MAIN_THREAD_HANDLERS.isEmpty() && defaultHandler != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    defaultHandler.onMessage(context, message);
                }
            }).start();
        }
        for (final MessageHandler handler : BACKGROUND_THREAD_HANDLERS) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    handler.onMessage(context, message);
                }
            }).start();
        }
        Looper main = Looper.getMainLooper();
        for (final MessageHandler handler : MAIN_THREAD_HANDLERS) {
            new Handler(main).post(new Runnable(){

                @Override
                public void run() {
                    handler.onMessage(context, message);
                }
            });
        }
    }

    protected static void notifyHandlers(Context context, Bundle message) {
        RegistrarManager.notifyHandlers(context, message, null);
    }

    static {
        RegistrarManager.registerConfigurationProvider(AeroGearFCMPushConfiguration.class, new AeroGearFCMPushConfigurationProvider());
        RegistrarManager.registerConfigurationProvider(AeroGearFCMPushJsonConfiguration.class, new AeroGearFCMPushJsonConfigurationProvider());
    }
}

