/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.fcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.pipe.http.HttpRestProvider;
import org.jboss.aerogear.android.pipe.util.UrlUtils;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.fcm.FCMSharedPreferenceProvider;
import org.jboss.aerogear.android.unifiedpush.fcm.UnifiedPushConfig;
import org.jboss.aerogear.android.unifiedpush.metrics.MetricsSender;
import org.jboss.aerogear.android.unifiedpush.metrics.UnifiedPushMetricsMessage;

public class AeroGearFCMPushRegistrar
implements PushRegistrar,
MetricsSender<UnifiedPushMetricsMessage> {
    private static final String BASIC_HEADER = "Authorization";
    private static final String AUTHORIZATION_METHOD = "Basic";
    private static final String LEGACY_PROPERTY_REG_ID = "registration_id";
    private static final Integer TIMEOUT = 30000;
    private static final String TAG = AeroGearFCMPushRegistrar.class.getSimpleName();
    static final String REGISTRAR_PREFERENCE_PATTERN = "org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:.+";
    static final String REGISTRAR_PREFERENCE_TEMPLATE = "org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:%s";
    private static final String registryDeviceEndpoint = "/rest/registry/device";
    private static final String metricsEndpoint = "/rest/registry/device/pushMessage";
    private static final String DEVICE_ALREADY_UNREGISTERED = "Seems this device was already unregistered";
    private final String senderId;
    private FirebaseInstanceId instanceId;
    private URL deviceRegistryURL;
    private URL metricsURL;
    private String deviceToken = "";
    private final String secret;
    private final String variantId;
    private final String deviceType;
    private final String alias;
    private final String operatingSystem;
    private final String osVersion;
    private final ArrayList<String> categories;
    private Provider<HttpProvider> httpProviderProvider = new Provider<HttpProvider>(){

        public HttpProvider get(Object ... in) {
            return new HttpRestProvider((URL)in[0], (Integer)in[1]);
        }
    };
    private Provider<FirebaseInstanceId> firebaseInstanceIdProvider = new Provider<FirebaseInstanceId>(){

        public FirebaseInstanceId get(Object ... context) {
            return FirebaseInstanceId.getInstance();
        }
    };
    private Provider<FirebaseMessaging> firebaseMessagingProvider = new Provider<FirebaseMessaging>(){

        public FirebaseMessaging get(Object ... context) {
            return FirebaseMessaging.getInstance();
        }
    };
    private Provider<SharedPreferences> preferenceProvider = new FCMSharedPreferenceProvider();

    public AeroGearFCMPushRegistrar(UnifiedPushConfig config) {
        this.senderId = config.getSenderId();
        this.deviceToken = config.getDeviceToken();
        this.variantId = config.getVariantID();
        this.secret = config.getSecret();
        this.deviceType = config.getDeviceType();
        this.alias = config.getAlias();
        this.operatingSystem = config.getOperatingSystem();
        this.osVersion = config.getOsVersion();
        this.categories = new ArrayList<String>(config.getCategories());
        try {
            this.deviceRegistryURL = UrlUtils.appendToBaseURL((URL)config.getPushServerURI().toURL(), (String)registryDeviceEndpoint);
            this.metricsURL = UrlUtils.appendToBaseURL((URL)config.getPushServerURI().toURL(), (String)metricsEndpoint);
        }
        catch (MalformedURLException ex) {
            Log.e((String)TAG, (String)ex.getMessage());
            throw new IllegalStateException("pushserverUrl was not a valid URL");
        }
    }

    @Override
    public void register(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    AeroGearFCMPushRegistrar.this.removeLegacyRegistrationId(context);
                    if (AeroGearFCMPushRegistrar.this.instanceId == null) {
                        AeroGearFCMPushRegistrar.this.instanceId = (FirebaseInstanceId)AeroGearFCMPushRegistrar.this.firebaseInstanceIdProvider.get(new Object[]{context});
                    }
                    String token = AeroGearFCMPushRegistrar.this.instanceId.getToken();
                    String oldToken = AeroGearFCMPushRegistrar.this.getOldToken(context);
                    if (token == null) {
                        token = AeroGearFCMPushRegistrar.this.instanceId.getToken(AeroGearFCMPushRegistrar.this.senderId, "FCM");
                    }
                    AeroGearFCMPushRegistrar.this.deviceToken = token;
                    HttpProvider httpProvider = (HttpProvider)AeroGearFCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearFCMPushRegistrar.this.deviceRegistryURL, TIMEOUT});
                    AeroGearFCMPushRegistrar.this.setPasswordAuthentication(AeroGearFCMPushRegistrar.this.variantId, AeroGearFCMPushRegistrar.this.secret, httpProvider);
                    httpProvider.setDefaultHeader("x-ag-old-token", oldToken);
                    try {
                        JsonObject postData = new JsonObject();
                        postData.addProperty("deviceType", AeroGearFCMPushRegistrar.this.deviceType);
                        postData.addProperty("deviceToken", AeroGearFCMPushRegistrar.this.deviceToken);
                        postData.addProperty("alias", AeroGearFCMPushRegistrar.this.alias);
                        postData.addProperty("operatingSystem", AeroGearFCMPushRegistrar.this.operatingSystem);
                        postData.addProperty("osVersion", AeroGearFCMPushRegistrar.this.osVersion);
                        if (AeroGearFCMPushRegistrar.this.categories != null && !AeroGearFCMPushRegistrar.this.categories.isEmpty()) {
                            JsonArray jsonCategories = new JsonArray();
                            for (String category : AeroGearFCMPushRegistrar.this.categories) {
                                jsonCategories.add((JsonElement)new JsonPrimitive(category));
                            }
                            postData.add("categories", (JsonElement)jsonCategories);
                        }
                        httpProvider.post(postData.toString());
                        postData.addProperty("deviceRegistryURL", AeroGearFCMPushRegistrar.this.deviceRegistryURL.toString());
                        postData.addProperty("variantId", AeroGearFCMPushRegistrar.this.variantId);
                        postData.addProperty("secret", AeroGearFCMPushRegistrar.this.secret);
                        AeroGearFCMPushRegistrar.this.presistPostInformation(context.getApplicationContext(), postData);
                        FirebaseMessaging firebaseMessaging = (FirebaseMessaging)AeroGearFCMPushRegistrar.this.firebaseMessagingProvider.get(new Object[]{context});
                        for (String catgory : AeroGearFCMPushRegistrar.this.categories) {
                            firebaseMessaging.subscribeToTopic(catgory);
                        }
                        firebaseMessaging.subscribeToTopic(AeroGearFCMPushRegistrar.this.variantId);
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else if (result instanceof HttpException) {
                    HttpException httpException = (HttpException)((Object)result);
                    switch (httpException.getStatusCode()) {
                        case 301: 
                        case 302: 
                        case 307: {
                            Log.w((String)TAG, (String)httpException.getMessage());
                            try {
                                URL redirectURL = new URL((String)httpException.getHeaders().get("Location"));
                                AeroGearFCMPushRegistrar.this.deviceRegistryURL = redirectURL;
                                AeroGearFCMPushRegistrar.this.register(context, (Callback<Void>)callback);
                            }
                            catch (MalformedURLException e) {
                                callback.onFailure((Exception)e);
                            }
                            break;
                        }
                        default: {
                            callback.onFailure(result);
                            break;
                        }
                    }
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    @Override
    public void unregister(final Context context, final Callback<Void> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    if (AeroGearFCMPushRegistrar.this.deviceToken == null || AeroGearFCMPushRegistrar.this.deviceToken.trim().equals("")) {
                        throw new IllegalStateException(AeroGearFCMPushRegistrar.DEVICE_ALREADY_UNREGISTERED);
                    }
                    if (AeroGearFCMPushRegistrar.this.instanceId == null) {
                        AeroGearFCMPushRegistrar.this.instanceId = (FirebaseInstanceId)AeroGearFCMPushRegistrar.this.firebaseInstanceIdProvider.get(new Object[]{context});
                    }
                    String token = AeroGearFCMPushRegistrar.this.instanceId.getToken();
                    FirebaseMessaging firebaseMessaging = (FirebaseMessaging)AeroGearFCMPushRegistrar.this.firebaseMessagingProvider.get(new Object[]{context});
                    for (String catgory : AeroGearFCMPushRegistrar.this.categories) {
                        firebaseMessaging.unsubscribeFromTopic(catgory);
                    }
                    firebaseMessaging.unsubscribeFromTopic(AeroGearFCMPushRegistrar.this.variantId);
                    AeroGearFCMPushRegistrar.this.instanceId.deleteInstanceId();
                    HttpProvider provider = (HttpProvider)AeroGearFCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearFCMPushRegistrar.this.deviceRegistryURL, TIMEOUT});
                    AeroGearFCMPushRegistrar.this.setPasswordAuthentication(AeroGearFCMPushRegistrar.this.variantId, AeroGearFCMPushRegistrar.this.secret, provider);
                    try {
                        provider.delete(AeroGearFCMPushRegistrar.this.deviceToken);
                        AeroGearFCMPushRegistrar.this.deviceToken = "";
                        AeroGearFCMPushRegistrar.this.removeSavedPostData(context.getApplicationContext());
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    @Override
    public void sendMetrics(final UnifiedPushMetricsMessage metricsMessage, final Callback<UnifiedPushMetricsMessage> callback) {
        new AsyncTask<Void, Void, Exception>(){

            protected Exception doInBackground(Void ... params) {
                try {
                    if (metricsMessage.getMessageId() == null || metricsMessage.getMessageId().trim().equals("")) {
                        throw new IllegalStateException("Message ID cannot be null or blank");
                    }
                    HttpProvider provider = (HttpProvider)AeroGearFCMPushRegistrar.this.httpProviderProvider.get(new Object[]{AeroGearFCMPushRegistrar.this.metricsURL, TIMEOUT});
                    AeroGearFCMPushRegistrar.this.setPasswordAuthentication(AeroGearFCMPushRegistrar.this.variantId, AeroGearFCMPushRegistrar.this.secret, provider);
                    try {
                        provider.put(metricsMessage.getMessageId(), "");
                        return null;
                    }
                    catch (HttpException ex) {
                        return ex;
                    }
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            protected void onPostExecute(Exception result) {
                if (result == null) {
                    callback.onSuccess((Object)metricsMessage);
                } else {
                    callback.onFailure(result);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    public void setPasswordAuthentication(String username, String password, HttpProvider provider) {
        provider.setDefaultHeader(BASIC_HEADER, this.getHashedAuth(username, password.toCharArray()));
    }

    private String getHashedAuth(String username, char[] password) {
        StringBuilder headerValueBuilder = new StringBuilder(AUTHORIZATION_METHOD).append(" ");
        String unhashedCredentials = username + ":" + password;
        String hashedCrentials = Base64.encodeToString((byte[])unhashedCredentials.getBytes(), (int)2);
        return headerValueBuilder.append(hashedCrentials).toString();
    }

    private void presistPostInformation(Context appContext, JsonObject postData) {
        ((SharedPreferences)this.preferenceProvider.get(new Object[]{appContext})).edit().putString(String.format(REGISTRAR_PREFERENCE_TEMPLATE, this.senderId), postData.toString()).commit();
    }

    private void removeSavedPostData(Context appContext) {
        ((SharedPreferences)this.preferenceProvider.get(new Object[]{appContext})).edit().remove(String.format(REGISTRAR_PREFERENCE_TEMPLATE, this.senderId)).commit();
    }

    private String getOldToken(Context appContext) {
        String jsonData = ((SharedPreferences)this.preferenceProvider.get(new Object[]{appContext})).getString(String.format(REGISTRAR_PREFERENCE_TEMPLATE, this.senderId), "");
        if (jsonData.isEmpty()) {
            return "";
        }
        JsonObject jsonedPreferences = new JsonParser().parse(jsonData).getAsJsonObject();
        try {
            return jsonedPreferences.get("deviceToken").getAsString();
        }
        catch (Exception ignore) {
            Log.w((String)TAG, (String)ignore.getMessage(), (Throwable)ignore);
            return "";
        }
    }

    private void removeLegacyRegistrationId(Context context) {
        try {
            SharedPreferences prefs = context.getSharedPreferences(AeroGearFCMPushRegistrar.class.getSimpleName(), 0);
            String registrationId = prefs.getString(LEGACY_PROPERTY_REG_ID, "");
            if (registrationId.length() != 0) {
                Log.v((String)TAG, (String)("Found legacy ID: '" + registrationId + "'"));
                HttpProvider provider = (HttpProvider)this.httpProviderProvider.get(new Object[]{this.deviceRegistryURL, TIMEOUT});
                this.setPasswordAuthentication(this.variantId, this.secret, provider);
                provider.delete(registrationId);
                prefs.edit().remove(LEGACY_PROPERTY_REG_ID).commit();
            }
        }
        catch (Exception ignore) {
            Log.v((String)TAG, (String)"Exception Thrown attempting to unregister legacy token", (Throwable)ignore);
        }
    }
}

