/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.aerogear.android.impl.crypto.InvalidKeyException;
import org.jboss.aerogear.crypto.CryptoBox;
import org.jboss.aerogear.crypto.keys.PrivateKey;

public class CryptoUtils<T> {
    private final CryptoBox cryptoBox;
    private final byte[] IV;
    private final Class<T> modelClass;
    private final Gson gson;

    public CryptoUtils(PrivateKey privateKey, byte[] iv, Class<T> modelClass) {
        this(privateKey, iv, modelClass, new GsonBuilder());
    }

    public CryptoUtils(PrivateKey privateKey, byte[] iv, Class<T> modelClass, GsonBuilder builder) {
        this.modelClass = modelClass;
        this.cryptoBox = new CryptoBox(privateKey);
        this.IV = iv;
        this.gson = builder.create();
    }

    public Collection<T> decrypt(Collection<byte[]> encryptedCollection) {
        ArrayList<T> decryptedList = new ArrayList<T>();
        for (byte[] encryptedItem : encryptedCollection) {
            decryptedList.add(this.decrypt(encryptedItem));
        }
        return decryptedList;
    }

    public byte[] encrypt(T item) {
        String json = this.gson.toJson(item);
        byte[] message = json.getBytes();
        return this.cryptoBox.encrypt(this.IV, message);
    }

    public T decrypt(byte[] data) {
        try {
            byte[] decryptedData = this.cryptoBox.decrypt(this.IV, data);
            String json = new String(decryptedData);
            return (T)this.gson.fromJson(json, this.modelClass);
        }
        catch (RuntimeException e) {
            throw new InvalidKeyException(e);
        }
    }
}

