/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.security;

import android.content.Context;
import java.util.Collection;
import java.util.HashSet;
import org.jboss.aerogear.android.Config;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.OnEncryptionServiceCreatedListener;

public abstract class CryptoConfiguration<CONFIGURATION extends CryptoConfiguration<CONFIGURATION>>
implements Config<CONFIGURATION> {
    private String name;
    private Context context;
    private Collection<OnEncryptionServiceCreatedListener> listeners = new HashSet<OnEncryptionServiceCreatedListener>();

    public Context getContext() {
        return this.context;
    }

    public CONFIGURATION setContext(Context context) {
        this.context = context;
        return (CONFIGURATION)this;
    }

    public String getName() {
        return this.name;
    }

    public CONFIGURATION setName(String name) {
        this.name = name;
        return (CONFIGURATION)this;
    }

    public final EncryptionService asService() {
        if (this.getContext() == null) {
            throw new IllegalStateException("An applicationContext must be provided");
        }
        EncryptionService newService = this.buildService();
        for (OnEncryptionServiceCreatedListener listener : this.getOnEncryptionServiceCreatedListeners()) {
            listener.onEncryptionServiceCreated(this, newService);
        }
        return newService;
    }

    protected abstract EncryptionService buildService();

    public Collection<OnEncryptionServiceCreatedListener> getOnEncryptionServiceCreatedListeners() {
        return this.listeners;
    }

    public CONFIGURATION addOnEncryptionServiceCreatedListener(OnEncryptionServiceCreatedListener listener) {
        this.listeners.add(listener);
        return (CONFIGURATION)this;
    }

    public CONFIGURATION setOnEncryptionServiceCreatedListeners(Collection<OnEncryptionServiceCreatedListener> listeners) {
        listeners.addAll(listeners);
        return (CONFIGURATION)this;
    }
}

