/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.security;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.ConfigurationProvider;
import org.jboss.aerogear.android.impl.security.PassphraseCryptoConfiguration;
import org.jboss.aerogear.android.impl.security.PasswordProtectedKeyStoreCryptoConfiguration;
import org.jboss.aerogear.android.security.CryptoConfiguration;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.OnEncryptionServiceCreatedListener;
import org.jboss.aerogear.android.security.PassphraseConfigurationProvider;
import org.jboss.aerogear.android.security.PasswordProtectedKeystoreCryptoConfigurationProvider;

public class CryptoManager {
    private static Map<String, EncryptionService> services = new HashMap<String, EncryptionService>();
    private static Map<Class<? extends CryptoConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnEncryptionServiceCreatedListener onEncryptionServiceCreatedListener = new OnEncryptionServiceCreatedListener(){

        @Override
        public void onEncryptionServiceCreated(CryptoConfiguration<?> configuration, EncryptionService service) {
            services.put(configuration.getName(), service);
        }
    };

    private CryptoManager() {
    }

    public static <CFG extends CryptoConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends CryptoConfiguration<CFG>> CFG config(String name, Class<CFG> cryptoConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(cryptoConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((CryptoConfiguration)provider.newConfiguration()).setName(name).addOnEncryptionServiceCreatedListener(onEncryptionServiceCreatedListener);
    }

    public static EncryptionService get(String name) {
        return services.get(name);
    }

    static {
        PassphraseConfigurationProvider passphraseCryptoConfigProvider = new PassphraseConfigurationProvider();
        CryptoManager.registerConfigurationProvider(PassphraseCryptoConfiguration.class, passphraseCryptoConfigProvider);
        PasswordProtectedKeystoreCryptoConfigurationProvider digestConfigurationProvider = new PasswordProtectedKeystoreCryptoConfigurationProvider();
        CryptoManager.registerConfigurationProvider(PasswordProtectedKeyStoreCryptoConfiguration.class, digestConfigurationProvider);
    }
}

