/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import org.jboss.aerogear.android.ConfigurationProvider;
import org.jboss.aerogear.android.DataManager;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.impl.datamanager.MemoryStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.SQLStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.StoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.store.test.MainActivity;

public class DataManagerTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    public DataManagerTest() {
        super(MainActivity.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testCreateStore() {
        Store store = ((MemoryStoreConfiguration)DataManager.config((String)"foo1", MemoryStoreConfiguration.class)).store();
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)store);
    }

    public void testGetStore() {
        ((MemoryStoreConfiguration)DataManager.config((String)"foo2", MemoryStoreConfiguration.class)).store();
        Store store = DataManager.getStore((String)"foo2");
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)store);
    }

    public void testCreateStoreType() {
        Store store = ((MemoryStoreConfiguration)DataManager.config((String)"foo3", MemoryStoreConfiguration.class)).store();
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)store);
        DataManagerTest.assertEquals((String)"store type should be MEMORY", (Object)StoreTypes.MEMORY, (Object)store.getType());
    }

    public void testCreateMoreThanOneStoreInDataManager() {
        ((MemoryStoreConfiguration)DataManager.config((String)"foo4", MemoryStoreConfiguration.class)).store();
        ((MemoryStoreConfiguration)DataManager.config((String)"foo5", MemoryStoreConfiguration.class)).store();
        Store store1 = DataManager.getStore((String)"foo4");
        Store store2 = DataManager.getStore((String)"foo5");
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)store1);
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)store2);
    }

    public void testCreateDiferentStore() {
        ((MemoryStoreConfiguration)DataManager.config((String)"foo6", MemoryStoreConfiguration.class)).store();
        ((SQLStoreConfiguration)DataManager.config((String)"foo7", SQLStoreConfiguration.class)).forClass(String.class).withContext(((MainActivity)this.getActivity()).getApplicationContext()).store();
        Store memoryStore = DataManager.getStore((String)"foo6");
        Store sqlStore = DataManager.getStore((String)"foo7");
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)memoryStore);
        DataManagerTest.assertEquals((String)"store type should be MEMORY", (Object)StoreTypes.MEMORY, (Object)memoryStore.getType());
        DataManagerTest.assertNotNull((String)"store could not be null", (Object)sqlStore);
        DataManagerTest.assertEquals((String)"store type should be MEMORY", (Object)StoreTypes.SQL, (Object)sqlStore.getType());
    }

    public void testAddNewProvider() {
        DataManager.registerConfigurationProvider(StubStoreConfiguration.class, (ConfigurationProvider)new DummyStoreConfigProvider());
        StubStoreConfiguration config = (StubStoreConfiguration)DataManager.config((String)"test", StubStoreConfiguration.class);
        DataManagerTest.assertNotNull((Object)((Object)config));
    }

    private static class StubStoreConfiguration
    extends StoreConfiguration<StubStoreConfiguration> {
        protected Store buildStore() {
            return null;
        }
    }

    private static final class DummyStoreConfigProvider
    implements ConfigurationProvider<StubStoreConfiguration> {
        private DummyStoreConfigProvider() {
        }

        public StubStoreConfiguration newConfiguration() {
            return new StubStoreConfiguration();
        }
    }
}

