/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.jboss.aerogear.android.DataManager;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.impl.datamanager.EncryptedMemoryStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.SQLStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.datamanager.StubIdGenerator;
import org.jboss.aerogear.android.impl.helper.Data;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.store.test.MainActivity;

public class EncryptedMemoryStoreTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private Store<Data> store;

    public EncryptedMemoryStoreTest() {
        super(MainActivity.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        StubIdGenerator stubIdGenerator = new StubIdGenerator();
        String passphrase = "Lorem Ipsum";
        Class<Data> dataModel = Data.class;
        this.store = ((EncryptedMemoryStoreConfiguration)DataManager.config((String)"testMemoryStore", EncryptedMemoryStoreConfiguration.class)).withIdGenerator((IdGenerator)stubIdGenerator).usingPassphrase(passphrase).forClass(dataModel).store();
    }

    public void testCreateSQLStoreWithoutKlass() {
        try {
            Store store1 = ((EncryptedMemoryStoreConfiguration)DataManager.config((String)"store1", EncryptedMemoryStoreConfiguration.class)).usingPassphrase("AeroGear").store();
            Data data = new Data(10, "name", "description");
            store1.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutPassphrase() {
        try {
            Store store2 = ((EncryptedMemoryStoreConfiguration)DataManager.config((String)"store2", EncryptedMemoryStoreConfiguration.class)).forClass(Data.class).store();
            Data data = new Data(10, "name", "description");
            store2.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutPassphraseAndKlass() {
        try {
            Store store3 = ((SQLStoreConfiguration)DataManager.config((String)"store3", SQLStoreConfiguration.class)).store();
            Data data = new Data(10, "name", "description");
            store3.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testStoreType() {
        EncryptedMemoryStoreTest.assertEquals((String)"verifying the type", (Object)StoreTypes.ENCRYPTED_MEMORY, (Object)this.store.getType());
    }

    public void testReadAll() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        Collection datas = this.store.readAll();
        EncryptedMemoryStoreTest.assertNotNull((String)"datas could not be null", (Object)datas);
        EncryptedMemoryStoreTest.assertEquals((String)"datas should 2 data", (int)2, (int)datas.size());
    }

    public void testReadWithFilter() {
        try {
            List datas = this.store.readWithFilter(new ReadFilter());
        }
        catch (UnsupportedOperationException ignore) {
            return;
        }
        EncryptedMemoryStoreTest.fail((String)"Should raise an exception");
    }

    public void testRead() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        Data data = (Data)this.store.read((Serializable)Integer.valueOf(1));
        EncryptedMemoryStoreTest.assertNotNull((String)"data could not be null", (Object)data);
    }

    public void testSaveNoExistRecord() {
        Data data = new Data("foo", "desc of foo");
        this.store.save((Object)data);
        EncryptedMemoryStoreTest.assertEquals((Object)1, (Object)data.getId());
    }

    public void testSaveExistRecord() {
        Data data = new Data("foo", "desc of foo");
        this.store.save((Object)data);
        data = new Data(1, "bar", "desc of bar");
        this.store.save((Object)data);
        data = (Data)this.store.read((Serializable)Integer.valueOf(1));
        EncryptedMemoryStoreTest.assertEquals((Object)1, (Object)data.getId());
        EncryptedMemoryStoreTest.assertEquals((String)"bar", (String)data.getName());
        EncryptedMemoryStoreTest.assertEquals((String)"desc of bar", (String)data.getDescription());
    }

    public void testReset() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        Data foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        EncryptedMemoryStoreTest.assertNotNull((String)"foo could not be null", (Object)foo);
        Data bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        EncryptedMemoryStoreTest.assertNotNull((String)"bar could not be null", (Object)bar);
        this.store.reset();
        foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        EncryptedMemoryStoreTest.assertNull((String)"foo should be null", (Object)foo);
        bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        EncryptedMemoryStoreTest.assertNull((String)"bar should be null", (Object)bar);
    }

    public void testRemove() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        Data foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        EncryptedMemoryStoreTest.assertNotNull((String)"foo could not be null", (Object)foo);
        Data bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        EncryptedMemoryStoreTest.assertNotNull((String)"bar could not be null", (Object)bar);
        this.store.remove((Serializable)Integer.valueOf(2));
        foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        EncryptedMemoryStoreTest.assertNotNull((String)"foo could not be null", (Object)foo);
        bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        EncryptedMemoryStoreTest.assertNull((String)"bar should be null", (Object)bar);
    }

    public void testIsEmpty() {
        EncryptedMemoryStoreTest.assertTrue((String)"should be empty", (boolean)this.store.isEmpty());
    }

    public void testIsNotEmpty() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        EncryptedMemoryStoreTest.assertFalse((String)"should not be empty", (boolean)this.store.isEmpty());
    }
}

