/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import android.content.Context;
import android.test.RenamingDelegatingContext;
import java.io.Serializable;
import java.util.UUID;
import junit.framework.Assert;
import org.jboss.aerogear.android.DataManager;
import org.jboss.aerogear.android.impl.datamanager.EncryptedSQLStore;
import org.jboss.aerogear.android.impl.datamanager.EncryptedSQLStoreConfiguration;
import org.jboss.aerogear.android.impl.helper.Data;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.store.test.MainActivity;

public class EncryptedSQLStoreTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private Context context;
    private EncryptedSQLStore<Data> store;

    public EncryptedSQLStoreTest() {
        super(MainActivity.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.context = new RenamingDelegatingContext((Context)this.getActivity(), UUID.randomUUID().toString());
        this.store = (EncryptedSQLStore)((EncryptedSQLStoreConfiguration)DataManager.config((String)"myTestStore", EncryptedSQLStoreConfiguration.class)).withContext(this.context).usingPassphrase("AeroGear").forClass(Data.class).store();
        this.store.openSync();
    }

    public void testCreateSQLStoreWithoutKlass() {
        try {
            EncryptedSQLStore store1 = (EncryptedSQLStore)((EncryptedSQLStoreConfiguration)DataManager.config((String)"store1", EncryptedSQLStoreConfiguration.class)).withContext(this.context).usingPassphrase("AeroGear").store();
            store1.openSync();
            Data data = new Data(10, "name", "description");
            store1.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutContext() {
        try {
            EncryptedSQLStore store2 = (EncryptedSQLStore)((EncryptedSQLStoreConfiguration)DataManager.config((String)"store2", EncryptedSQLStoreConfiguration.class)).forClass(Data.class).usingPassphrase("AeroGear").store();
            store2.openSync();
            Data data = new Data(10, "name", "description");
            store2.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutPassphrase() {
        try {
            EncryptedSQLStore store3 = (EncryptedSQLStore)((EncryptedSQLStoreConfiguration)DataManager.config((String)"store3", EncryptedSQLStoreConfiguration.class)).withContext(this.context).forClass(String.class).store();
            store3.openSync();
            Data data = new Data(10, "name", "description");
            store3.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutContextAndKlassAndPassphrase() {
        try {
            EncryptedSQLStore store4 = (EncryptedSQLStore)((EncryptedSQLStoreConfiguration)DataManager.config((String)"store3", EncryptedSQLStoreConfiguration.class)).store();
            store4.openSync();
            Data data = new Data(10, "name", "description");
            store4.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testReadAll() {
        for (int i = 1; i <= 10; ++i) {
            Data data = new Data(i, "name " + i, "description " + i);
            this.store.save((Object)data);
        }
        EncryptedSQLStoreTest.assertEquals((String)"Store should have 10 elements", (int)10, (int)this.store.readAll().size());
    }

    public void testRead() {
        Data data = new Data(10, "name", "description");
        this.store.save((Object)data);
        Data readData = (Data)this.store.read((Serializable)Integer.valueOf(10));
        EncryptedSQLStoreTest.assertEquals((Object)data, (Object)readData);
        EncryptedSQLStoreTest.assertTrue((String)"Store can not be empty", (!this.store.isEmpty() ? 1 : 0) != 0);
    }

    public void testSave() {
        Data data = new Data(10, "name", "description");
        this.store.save((Object)data);
        EncryptedSQLStoreTest.assertFalse((String)"Store can not be empty", (boolean)this.store.isEmpty());
        EncryptedSQLStoreTest.assertEquals((String)"Store should have 1 elements", (int)1, (int)this.store.readAll().size());
    }

    public void testReset() {
        Data data = new Data(10, "name", "description");
        this.store.save((Object)data);
        this.store.reset();
        EncryptedSQLStoreTest.assertTrue((String)"Store can empty", (boolean)this.store.isEmpty());
    }

    public void testRemove() {
        for (int i = 1; i <= 10; ++i) {
            Data data = new Data(i, "name " + i, "description " + i);
            this.store.save((Object)data);
        }
        this.store.remove((Serializable)Integer.valueOf(1));
        EncryptedSQLStoreTest.assertEquals((String)"Store should have 9 elements", (int)9, (int)this.store.readAll().size());
    }

    public void testIsEmpty() {
        EncryptedSQLStoreTest.assertTrue((String)"Store can empty", (boolean)this.store.isEmpty());
    }

    public void testIsNotEmpty() {
        Data data = new Data(10, "name", "description");
        this.store.save((Object)data);
        EncryptedSQLStoreTest.assertFalse((String)"Store can not be empty", (boolean)this.store.isEmpty());
    }
}

