/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.android.DataManager;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreType;
import org.jboss.aerogear.android.impl.datamanager.MemoryStore;
import org.jboss.aerogear.android.impl.datamanager.MemoryStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.datamanager.StubIdGenerator;
import org.jboss.aerogear.android.impl.helper.Data;
import org.jboss.aerogear.android.impl.helper.DataWithNoIdConfigured;
import org.jboss.aerogear.android.impl.helper.DataWithNoPropertyId;
import org.jboss.aerogear.android.impl.reflection.PropertyNotFoundException;
import org.jboss.aerogear.android.impl.reflection.RecordIdNotFoundException;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.store.test.MainActivity;
import org.json.JSONException;
import org.json.JSONObject;

public class MemoryStoreTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private Store<Data> store;
    private StubIdGenerator stubIdGenerator;

    public MemoryStoreTest() {
        super(MainActivity.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.stubIdGenerator = new StubIdGenerator();
        this.store = ((MemoryStoreConfiguration)DataManager.config((String)"testMemoryStore", MemoryStoreConfiguration.class)).withIdGenerator((IdGenerator)this.stubIdGenerator).store();
    }

    public void testStoreType() {
        MemoryStoreTest.assertEquals((String)"verifying the type", (Object)StoreTypes.MEMORY, (Object)this.store.getType());
    }

    public void testReadAll() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        Collection datas = this.store.readAll();
        MemoryStoreTest.assertNotNull((String)"datas could not be null", (Object)datas);
        MemoryStoreTest.assertEquals((String)"datas should 2 data", (int)2, (int)datas.size());
    }

    public void testReadWithFilter() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        List datas = this.store.readWithFilter(new ReadFilter());
        MemoryStoreTest.assertNotNull((String)"datas could not be null", (Object)datas);
        MemoryStoreTest.assertEquals((String)"datas should 2 data", (int)2, (int)datas.size());
    }

    public void testReadWithFilterPerPage() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        ReadFilter filter = new ReadFilter();
        filter.setLimit(Integer.valueOf(1));
        List datas = this.store.readWithFilter(filter);
        MemoryStoreTest.assertNotNull((String)"datas could not be null", (Object)datas);
        MemoryStoreTest.assertEquals((String)"datas should 1 data", (int)1, (int)datas.size());
        MemoryStoreTest.assertEquals((String)"foo", (String)((Data)datas.iterator().next()).getName());
        filter.setOffset(Integer.valueOf(1));
        datas = this.store.readWithFilter(filter);
        MemoryStoreTest.assertEquals((String)"bar", (String)((Data)datas.iterator().next()).getName());
    }

    public void testReadWithFilterWhere() throws JSONException {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        ReadFilter filter = new ReadFilter();
        filter.setWhere(new JSONObject("{\"name\":\"bar\"}"));
        List datas = this.store.readWithFilter(filter);
        MemoryStoreTest.assertNotNull((String)"datas could not be null", (Object)datas);
        MemoryStoreTest.assertEquals((String)"datas should 1 data", (int)1, (int)datas.size());
        MemoryStoreTest.assertEquals((String)"bar", (String)((Data)datas.iterator().next()).getName());
    }

    public void testReadWithFilterThrowsExceptionWithNestingJSON() throws JSONException {
        try {
            ReadFilter filter = new ReadFilter();
            filter.setWhere(new JSONObject("{\"name\":{\"name\":\"bar\"}}"));
            List list = this.store.readWithFilter(filter);
        }
        catch (IllegalArgumentException ignore) {
            return;
        }
        MemoryStoreTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testRead() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        Data data = (Data)this.store.read((Serializable)Integer.valueOf(1));
        MemoryStoreTest.assertNotNull((String)"data could not be null", (Object)data);
    }

    public void testSaveNoExistRecord() {
        Data data = new Data("foo", "desc of foo");
        this.store.save((Object)data);
        MemoryStoreTest.assertEquals((Object)1, (Object)data.getId());
    }

    public void testSaveExistRecord() {
        Data data = new Data("foo", "desc of foo");
        this.store.save((Object)data);
        data = new Data(1, "bar", "desc of bar");
        this.store.save((Object)data);
        data = (Data)this.store.read((Serializable)Integer.valueOf(1));
        MemoryStoreTest.assertEquals((Object)1, (Object)data.getId());
        MemoryStoreTest.assertEquals((String)"bar", (String)data.getName());
        MemoryStoreTest.assertEquals((String)"desc of bar", (String)data.getDescription());
    }

    public void testSaveWithAnnotationNotConfigured() {
        try {
            MemoryStore memoryStore = new MemoryStore((IdGenerator)this.stubIdGenerator);
            memoryStore.save((Object)new DataWithNoIdConfigured());
        }
        catch (RecordIdNotFoundException ignore) {
            return;
        }
        MemoryStoreTest.fail((String)"Expected RecordIdNotFoundException");
    }

    public void testSaveWithNoPropertyToSetId() {
        try {
            MemoryStore memoryStore = new MemoryStore((IdGenerator)this.stubIdGenerator);
            memoryStore.save((Object)new DataWithNoPropertyId());
        }
        catch (PropertyNotFoundException ignore) {
            return;
        }
        MemoryStoreTest.fail((String)"Expected PropertyNotFoundException");
    }

    public void testReset() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        Data foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        MemoryStoreTest.assertNotNull((String)"foo could not be null", (Object)foo);
        Data bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        MemoryStoreTest.assertNotNull((String)"bar could not be null", (Object)bar);
        this.store.reset();
        foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        MemoryStoreTest.assertNull((String)"foo should be null", (Object)foo);
        bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        MemoryStoreTest.assertNull((String)"bar should be null", (Object)bar);
    }

    public void testRemove() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        this.store.save((Object)new Data("bar", "desc of bar"));
        Data foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        MemoryStoreTest.assertNotNull((String)"foo could not be null", (Object)foo);
        Data bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        MemoryStoreTest.assertNotNull((String)"bar could not be null", (Object)bar);
        this.store.remove((Serializable)Integer.valueOf(2));
        foo = (Data)this.store.read((Serializable)Integer.valueOf(1));
        MemoryStoreTest.assertNotNull((String)"foo could not be null", (Object)foo);
        bar = (Data)this.store.read((Serializable)Integer.valueOf(2));
        MemoryStoreTest.assertNull((String)"bar should be null", (Object)bar);
    }

    public void testIsEmpty() {
        MemoryStoreTest.assertTrue((String)"should be empty", (boolean)this.store.isEmpty());
    }

    public void testIsNotEmpty() {
        this.store.save((Object)new Data("foo", "desc of foo"));
        MemoryStoreTest.assertFalse((String)"should not be empty", (boolean)this.store.isEmpty());
    }

    private static class FakeStoreType
    implements StoreType {
        private FakeStoreType() {
        }

        public String getName() {
            return "FAKE";
        }
    }
}

