/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import android.content.Context;
import android.test.RenamingDelegatingContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.DataManager;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.RecordId;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.impl.datamanager.SQLStore;
import org.jboss.aerogear.android.impl.datamanager.SQLStoreConfiguration;
import org.jboss.aerogear.android.impl.helper.Data;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.store.test.MainActivity;
import org.json.JSONException;
import org.json.JSONObject;

public class SqlStoreTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    private Context context;
    private SQLStore<Data> store;
    private SQLStore<TrivialNestedClass> nestedStore;
    private SQLStore<TrivialNestedClassWithCollection> nestedWithCollectionStore;

    public SqlStoreTest() {
        super(MainActivity.class);
    }

    protected void runTest() throws Throwable {
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac os x") || !System.getProperty("java.version").startsWith("1.7.0")) {
            super.runTest();
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.context = new RenamingDelegatingContext((Context)this.getActivity(), UUID.randomUUID().toString());
        this.store = (SQLStore)((SQLStoreConfiguration)DataManager.config((String)"store", SQLStoreConfiguration.class)).forClass(Data.class).withContext(this.context).store();
        this.nestedStore = (SQLStore)((SQLStoreConfiguration)DataManager.config((String)"trivialNestedClass", SQLStoreConfiguration.class)).forClass(TrivialNestedClass.class).withContext(this.context).store();
        this.nestedWithCollectionStore = (SQLStore)((SQLStoreConfiguration)DataManager.config((String)"trivialNestedClassWithCollection", SQLStoreConfiguration.class)).forClass(TrivialNestedClassWithCollection.class).withContext(this.context).store();
    }

    public void testCreateSQLStoreWithoutKlass() {
        try {
            Store store1 = ((SQLStoreConfiguration)DataManager.config((String)"store1", SQLStoreConfiguration.class)).withContext(this.context).store();
            Data data = new Data(10, "name", "description");
            store1.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutContext() {
        try {
            Store store2 = ((SQLStoreConfiguration)DataManager.config((String)"store2", SQLStoreConfiguration.class)).forClass(Data.class).store();
            Data data = new Data(10, "name", "description");
            store2.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCreateSQLStoreWithoutContextAndKlass() {
        try {
            Store store3 = ((SQLStoreConfiguration)DataManager.config((String)"store3", SQLStoreConfiguration.class)).store();
            Data data = new Data(10, "name", "description");
            store3.save((Object)data);
            Assert.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSave() throws InterruptedException {
        Data data = new Data(10, "name", "description");
        data.setEnable(true);
        this.saveData(10, "name", "description", true);
        Data readData = (Data)this.store.read((Serializable)Integer.valueOf(10));
        SqlStoreTest.assertEquals((Object)data, (Object)readData);
    }

    public void testReset() throws InterruptedException {
        this.saveData(10, "name", "description");
        this.store.reset();
        Data readData = (Data)this.store.read((Serializable)Integer.valueOf(10));
        SqlStoreTest.assertNull((Object)readData);
    }

    public void testIsEmpty() throws InterruptedException {
        this.store.openSync();
        SqlStoreTest.assertTrue((boolean)this.store.isEmpty());
    }

    public void testIsNotEmpty() throws InterruptedException {
        this.saveData(10, "name", "description");
        SqlStoreTest.assertFalse((boolean)this.store.isEmpty());
    }

    public void testReadAll() throws InterruptedException, JSONException {
        this.loadBulkData();
        ArrayList allData = new ArrayList(this.store.readAll());
        Collections.sort(allData);
        SqlStoreTest.assertEquals((int)6, (int)allData.size());
        SqlStoreTest.assertEquals((String)"name", (String)((Data)allData.get(0)).getName());
        SqlStoreTest.assertEquals((String)"name2", (String)((Data)allData.get(5)).getName());
    }

    public void testRemove() throws InterruptedException, JSONException {
        this.loadBulkData();
        this.store.remove((Serializable)Integer.valueOf(1));
        ArrayList allData = new ArrayList(this.store.readAll());
        Collections.sort(allData);
        SqlStoreTest.assertEquals((int)5, (int)allData.size());
        SqlStoreTest.assertEquals((long)2L, (long)((Data)allData.get(0)).getId().intValue());
        SqlStoreTest.assertEquals((String)"name2", (String)((Data)allData.get(4)).getName());
    }

    public void testFilter() throws InterruptedException, JSONException {
        this.loadBulkData();
        List result = this.store.readWithFilter(null);
        SqlStoreTest.assertEquals((int)6, (int)result.size());
        ReadFilter filter = new ReadFilter();
        JSONObject where = new JSONObject();
        where.put("name", (Object)"name2");
        filter.setWhere(where);
        result = this.store.readWithFilter(filter);
        SqlStoreTest.assertEquals((int)3, (int)result.size());
        filter = new ReadFilter();
        where = new JSONObject();
        where.put("name", (Object)"name2");
        where.put("description", (Object)"description");
        filter.setWhere(where);
        result = this.store.readWithFilter(filter);
        SqlStoreTest.assertEquals((int)2, (int)result.size());
    }

    public void testNestedSaveAndFilter() throws InterruptedException, JSONException {
        Data data = new Data(10, "name", "description");
        TrivialNestedClass newNested = new TrivialNestedClass();
        newNested.setId(1);
        newNested.setText("nestedText");
        newNested.setData(data);
        this.nestedStore.openSync();
        this.nestedStore.save((Object)newNested);
        ReadFilter filter = new ReadFilter();
        JSONObject where = new JSONObject();
        where.put("text", (Object)"nestedText");
        JSONObject dataFilter = new JSONObject();
        dataFilter.put("id", 10);
        where.put("data", (Object)dataFilter);
        filter.setWhere(where);
        List result = this.nestedStore.readWithFilter(filter);
        SqlStoreTest.assertEquals((int)1, (int)result.size());
        TrivialNestedClass nestedResult = (TrivialNestedClass)result.get(0);
        SqlStoreTest.assertEquals((String)"name", (String)nestedResult.data.getName());
    }

    public void testNestedListSaveAndFilter() throws InterruptedException, JSONException {
        ArrayList<Data> data = new ArrayList<Data>();
        data.add(new Data(10, "name", "description"));
        data.add(new Data(30, "name", "description"));
        TrivialNestedClassWithCollection newNested = new TrivialNestedClassWithCollection();
        newNested.setId(1);
        newNested.setText("nestedText");
        newNested.setData(data);
        this.nestedWithCollectionStore.openSync();
        this.nestedWithCollectionStore.save((Object)newNested);
        ReadFilter filter = new ReadFilter();
        JSONObject where = new JSONObject();
        where.put("text", (Object)"nestedText");
        where.put("id", 1);
        filter.setWhere(where);
        List result = this.nestedWithCollectionStore.readWithFilter(filter);
        SqlStoreTest.assertEquals((int)1, (int)result.size());
        TrivialNestedClassWithCollection nestedResult = (TrivialNestedClassWithCollection)result.get(0);
        SqlStoreTest.assertEquals((Object)10, (Object)((Data)nestedResult.data.get(0)).getId());
        SqlStoreTest.assertEquals((Object)30, (Object)((Data)nestedResult.data.get(1)).getId());
    }

    public void testSuccessCallback() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(2);
        this.store.open((Callback)new Callback<SQLStore<Data>>(){

            public void onSuccess(SQLStore<Data> data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                throw new RuntimeException(e);
            }
        });
        SqlStoreTest.assertFalse((String)"OnSuccess should be called exactly once!", (boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    private void saveData(Integer id, String name, String desc) throws InterruptedException {
        this.store.openSync();
        this.store.save((Object)new Data(id, name, desc));
    }

    private void saveData(Integer id, String name, String desc, boolean enable) throws InterruptedException {
        this.store.openSync();
        this.store.save((Object)new Data(id, name, desc, enable));
    }

    public void testSaveListOfBoringData() throws InterruptedException {
        SQLStore longStore = new SQLStore(ListWithId.class, this.context);
        longStore.openSync();
        ListWithId longList = new ListWithId(100);
        longList.setId(1);
        for (long i = 0L; i < 100L; ++i) {
            longList.data.add(i);
        }
        longStore.save(longList);
        SqlStoreTest.assertEquals((int)100, (int)((ListWithId)longStore.readAll().iterator().next()).data.size());
    }

    private void loadBulkData() throws InterruptedException {
        this.saveData(1, "name", "description");
        this.saveData(2, "name", "description");
        this.saveData(3, "name2", "description");
        this.saveData(4, "name2", "description");
        this.saveData(5, "name", "description2");
        this.saveData(6, "name2", "description2");
    }

    public static final class ListWithId<T> {
        @RecordId
        private Integer id;
        public final List<T> data;

        public ListWithId(int size) {
            this.data = new ArrayList<T>(size);
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }

    public static final class TrivialNestedClassWithCollection {
        @RecordId
        private Integer id;
        private String text;
        private List<Data> data;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<Data> getData() {
            return this.data;
        }

        public void setData(List<Data> data) {
            this.data = data;
        }
    }

    public static final class TrivialNestedClass {
        @RecordId
        private Integer id;
        private String text;
        private Data data;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }
    }
}

