/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import android.content.Context;
import com.google.gson.GsonBuilder;
import org.jboss.aerogear.android.Config;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.impl.datamanager.DefaultIdGenerator;
import org.jboss.aerogear.android.impl.datamanager.EncryptedSQLStore;
import org.jboss.aerogear.android.impl.datamanager.StoreConfiguration;

public final class EncryptedSQLStoreConfiguration
extends StoreConfiguration<EncryptedSQLStoreConfiguration>
implements Config<EncryptedSQLStoreConfiguration> {
    private Class klass;
    private Context context;
    private GsonBuilder builder = new GsonBuilder();
    private IdGenerator idGenerator = new DefaultIdGenerator();
    private String passphrase;

    public EncryptedSQLStoreConfiguration forClass(Class klass) {
        this.klass = klass;
        return this;
    }

    public EncryptedSQLStoreConfiguration withContext(Context context) {
        this.context = context;
        return this;
    }

    public EncryptedSQLStoreConfiguration withGsonBuilder(GsonBuilder builder) {
        this.builder = builder;
        return this;
    }

    public EncryptedSQLStoreConfiguration withIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public EncryptedSQLStoreConfiguration usingPassphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @Override
    protected Store buildStore() {
        if (this.klass == null || this.passphrase == null || this.context == null) {
            throw new IllegalStateException("Klass, Passphrase and Context are mandatory");
        }
        return new EncryptedSQLStore(this.klass, this.context, this.builder, this.idGenerator, this.passphrase);
    }
}

