/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.aerogear.android.Config;
import org.jboss.aerogear.android.datamanager.OnStoreCreatedListener;
import org.jboss.aerogear.android.datamanager.Store;

public abstract class StoreConfiguration<CONFIGURATION extends StoreConfiguration<CONFIGURATION>>
implements Config<CONFIGURATION> {
    private String name;
    private Collection<OnStoreCreatedListener> listeners = new HashSet<OnStoreCreatedListener>();

    public String getName() {
        return this.name;
    }

    public CONFIGURATION setName(String name) {
        this.name = name;
        return (CONFIGURATION)this;
    }

    public Collection<OnStoreCreatedListener> getOnStoreCreatedListeners() {
        return this.listeners;
    }

    public CONFIGURATION addOnStoreCreatedListener(OnStoreCreatedListener listener) {
        this.listeners.add(listener);
        return (CONFIGURATION)this;
    }

    public CONFIGURATION setOnStoreCreatedListeners(Collection<OnStoreCreatedListener> listeners) {
        listeners.addAll(listeners);
        return (CONFIGURATION)this;
    }

    public final Store store() {
        Store store = this.buildStore();
        for (OnStoreCreatedListener listener : this.getOnStoreCreatedListeners()) {
            listener.onStoreCreated(this, store);
        }
        return store;
    }

    protected abstract Store buildStore();
}

