/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.store.OnStoreCreatedListener;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.StoreConfiguration;
import org.jboss.aerogear.android.store.memory.EncryptedMemoryStoreConfiguration;
import org.jboss.aerogear.android.store.memory.EncryptedMemoryStoreConfigurationProvider;
import org.jboss.aerogear.android.store.memory.MemoryStoreConfiguration;
import org.jboss.aerogear.android.store.memory.MemoryStoreConfigurationProvider;
import org.jboss.aerogear.android.store.sql.EncryptedSQLStoreConfiguration;
import org.jboss.aerogear.android.store.sql.EncryptedSQLStoreConfigurationProvider;
import org.jboss.aerogear.android.store.sql.SQLStoreConfiguration;
import org.jboss.aerogear.android.store.sql.SQLStoreConfigurationProvider;

public final class DataManager {
    private static Map<String, Store<?>> stores = new HashMap();
    private static Map<Class<? extends StoreConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnStoreCreatedListener onStoreCreatedListener = new OnStoreCreatedListener(){

        @Override
        public void onStoreCreated(StoreConfiguration<?> configuration, Store<?> store) {
            stores.put(configuration.getName(), store);
        }
    };

    private DataManager() {
    }

    public static <CONFIGURATION extends StoreConfiguration<CONFIGURATION>> void registerConfigurationProvider(Class<CONFIGURATION> configurationClass, ConfigurationProvider<CONFIGURATION> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends StoreConfiguration<CFG>> CFG config(String name, Class<CFG> storeImplementationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(storeImplementationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((StoreConfiguration)provider.newConfiguration()).setName(name).addOnStoreCreatedListener(onStoreCreatedListener);
    }

    public static Store getStore(String name) {
        return stores.get(name);
    }

    static {
        DataManager.registerConfigurationProvider(MemoryStoreConfiguration.class, new MemoryStoreConfigurationProvider());
        DataManager.registerConfigurationProvider(SQLStoreConfiguration.class, new SQLStoreConfigurationProvider());
        DataManager.registerConfigurationProvider(EncryptedMemoryStoreConfiguration.class, new EncryptedMemoryStoreConfigurationProvider());
        DataManager.registerConfigurationProvider(EncryptedSQLStoreConfiguration.class, new EncryptedSQLStoreConfigurationProvider());
    }
}

