/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store.memory;

import org.jboss.aerogear.android.core.Config;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.StoreConfiguration;
import org.jboss.aerogear.android.store.generator.DefaultIdGenerator;
import org.jboss.aerogear.android.store.generator.IdGenerator;
import org.jboss.aerogear.android.store.memory.EncryptedMemoryStore;

public final class EncryptedMemoryStoreConfiguration
extends StoreConfiguration<EncryptedMemoryStoreConfiguration>
implements Config<EncryptedMemoryStoreConfiguration> {
    private IdGenerator idGenerator = new DefaultIdGenerator();
    private String passphrase;
    private Class klass;

    public EncryptedMemoryStoreConfiguration withIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public EncryptedMemoryStoreConfiguration usingPassphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    public EncryptedMemoryStoreConfiguration forClass(Class klass) {
        this.klass = klass;
        return this;
    }

    @Override
    protected Store buildStore() {
        if (this.klass == null || this.passphrase == null) {
            throw new IllegalStateException("Klass and Passphrase are mandatory");
        }
        return new EncryptedMemoryStore(this.idGenerator, this.passphrase, this.klass);
    }
}

