/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store.memory;

import java.io.Serializable;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.android.core.ReadFilter;
import org.jboss.aerogear.android.security.InvalidKeyException;
import org.jboss.aerogear.android.security.util.CryptoUtils;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.generator.IdGenerator;
import org.jboss.aerogear.android.store.memory.MemoryStore;
import org.jboss.aerogear.crypto.RandomUtils;
import org.jboss.aerogear.crypto.keys.PrivateKey;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class EncryptedMemoryStore<T>
implements Store<T> {
    private final MemoryStore<byte[]> memoryStore;
    private final CryptoUtils<T> cryptoUtils;

    public EncryptedMemoryStore(IdGenerator idGenerator, String passphrase, Class<T> modelClass) {
        this.memoryStore = new MemoryStore(idGenerator);
        byte[] iv = RandomUtils.randomBytes();
        byte[] salt = RandomUtils.randomBytes();
        byte[] rawPassword = new byte[]{};
        try {
            Pbkdf2 pbkdf2 = AeroGearCrypto.pbkdf2();
            rawPassword = pbkdf2.encrypt(passphrase, salt);
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        PrivateKey privateKey = new PrivateKey(rawPassword);
        this.cryptoUtils = new CryptoUtils(privateKey, iv, modelClass);
    }

    @Override
    public Collection<T> readAll() throws InvalidKeyException {
        Collection<byte[]> encryptedCollection = this.memoryStore.readAll();
        return this.cryptoUtils.decrypt(encryptedCollection);
    }

    @Override
    public T read(Serializable id) throws InvalidKeyException {
        byte[] encryptedItem = this.memoryStore.read(id);
        if (encryptedItem == null) {
            return null;
        }
        return (T)this.cryptoUtils.decrypt(encryptedItem);
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(T item) {
        Serializable idValue = this.memoryStore.getOrGenerateIdValue(item);
        this.memoryStore.save(idValue, this.cryptoUtils.encrypt(item));
    }

    @Override
    public void save(Collection<T> items) {
        for (T item : items) {
            this.save(item);
        }
    }

    @Override
    public void reset() {
        this.memoryStore.reset();
    }

    @Override
    public void remove(Serializable id) {
        this.memoryStore.remove(id);
    }

    @Override
    public boolean isEmpty() {
        return this.memoryStore.isEmpty();
    }
}

