/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.aerogear.android.core.Config;
import org.jboss.aerogear.android.store.OnStoreCreatedListener;
import org.jboss.aerogear.android.store.Store;

public abstract class StoreConfiguration<CONFIGURATION extends StoreConfiguration<CONFIGURATION>>
implements Config<CONFIGURATION> {
    private String name;
    private Collection<OnStoreCreatedListener> listeners = new HashSet<OnStoreCreatedListener>();

    public String getName() {
        return this.name;
    }

    public CONFIGURATION setName(String name) {
        this.name = name;
        return (CONFIGURATION)this;
    }

    public Collection<OnStoreCreatedListener> getOnStoreCreatedListeners() {
        return this.listeners;
    }

    public CONFIGURATION addOnStoreCreatedListener(OnStoreCreatedListener listener) {
        this.listeners.add(listener);
        return (CONFIGURATION)this;
    }

    public CONFIGURATION setOnStoreCreatedListeners(Collection<OnStoreCreatedListener> listeners) {
        listeners.addAll(listeners);
        return (CONFIGURATION)this;
    }

    public final <TYPE> Store<TYPE> store(Class<TYPE> klass) {
        Store<TYPE> store = this.buildStore(klass);
        for (OnStoreCreatedListener listener : this.getOnStoreCreatedListeners()) {
            listener.onStoreCreated(this, store);
        }
        return store;
    }

    protected abstract <TYPE> Store<TYPE> buildStore(Class<TYPE> var1);
}

