/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android;

import android.util.Log;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.json.JSONObject;

public class ReadFilter
implements Serializable {
    private static final String UTF_8 = "UTF-8";
    private static final String TAG = ReadFilter.class.getSimpleName();
    private Integer limit = Integer.MAX_VALUE;
    private Integer offset = 0;
    private JSONObject where = new JSONObject();
    private URI linkUri;

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public JSONObject getWhere() {
        return this.where;
    }

    public void setWhere(JSONObject where) {
        this.where = where;
    }

    public URI getLinkUri() {
        return this.linkUri;
    }

    public void setLinkUri(URI linkUri) {
        this.linkUri = linkUri;
    }

    public String getQuery() {
        StringBuilder queryBuilder = new StringBuilder("?");
        String amp = "";
        if (this.limit != null && this.limit != Integer.MAX_VALUE) {
            queryBuilder.append(amp).append("limit=").append(this.limit);
            amp = "&";
        }
        if (this.offset != null && this.offset > 0) {
            queryBuilder.append(amp).append("offset=").append(this.offset);
            amp = "&";
        }
        if (this.where != null && this.where.length() > 0) {
            try {
                queryBuilder.append(amp).append("where=").append(URLEncoder.encode(this.where.toString(), UTF_8).replace("%3A", ":"));
            }
            catch (UnsupportedEncodingException ex) {
                Log.e((String)TAG, (String)"UTF-8 isn't supported on this platform", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            amp = "&";
        }
        return queryBuilder.toString();
    }
}

